/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.mail.internet.SharedInputStream;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.Property;

public class SimpleMessage
implements Message {
    private final MessageId messageId;
    private final String subType;
    private final String mediaType;
    private final SharedInputStream content;
    private final int bodyStartOctet;
    private final Date internalDate;
    private final long size;
    private final Long textualLineCount;
    private final List<Property> properties;
    private final List<MessageAttachment> attachments;

    public SimpleMessage(MessageId messageId, SharedInputStream content, long size, Date internalDate, String subType, String mediaType, int bodyStartOctet, Long textualLineCount, List<Property> properties, List<MessageAttachment> attachments) {
        this.messageId = messageId;
        this.subType = subType;
        this.mediaType = mediaType;
        this.content = content;
        this.bodyStartOctet = bodyStartOctet;
        this.internalDate = internalDate;
        this.size = size;
        this.textualLineCount = textualLineCount;
        this.properties = properties;
        this.attachments = attachments;
    }

    public SimpleMessage(MessageId messageId, SharedInputStream content, long size, Date internalDate, String subType, String mediaType, int bodyStartOctet, Long textualLineCount, List<Property> properties) {
        this(messageId, content, size, internalDate, subType, mediaType, bodyStartOctet, textualLineCount, properties, (List<MessageAttachment>)ImmutableList.of());
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    @Override
    public Date getInternalDate() {
        return this.internalDate;
    }

    @Override
    public InputStream getBodyContent() throws IOException {
        return this.content.newStream((long)this.bodyStartOctet, -1L);
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getSubType() {
        return this.subType;
    }

    @Override
    public long getBodyOctets() {
        return this.getFullContentOctets() - (long)this.bodyStartOctet;
    }

    @Override
    public long getFullContentOctets() {
        return this.size;
    }

    @Override
    public Long getTextualLineCount() {
        return this.textualLineCount;
    }

    @Override
    public InputStream getHeaderContent() throws IOException {
        long headerEnd = this.bodyStartOctet;
        if (headerEnd < 0L) {
            headerEnd = 0L;
        }
        return this.content.newStream(0L, headerEnd);
    }

    @Override
    public InputStream getFullContent() throws IOException {
        return this.content.newStream(0L, -1L);
    }

    @Override
    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public List<MessageAttachment> getAttachments() {
        return this.attachments;
    }
}

