/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.DelegatingMailboxMessage;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMessage;

public class SimpleMailboxMessage
extends DelegatingMailboxMessage {
    private MessageUid uid;
    private final MailboxId mailboxId;
    private boolean answered;
    private boolean deleted;
    private boolean draft;
    private boolean flagged;
    private boolean recent;
    private boolean seen;
    private String[] userFlags;
    private long modSeq;

    public static SimpleMailboxMessage copy(MailboxId mailboxId, MailboxMessage original) throws MailboxException {
        return SimpleMailboxMessage.copy(mailboxId, original, original.getAttachments());
    }

    private static SimpleMailboxMessage copy(MailboxId mailboxId, MailboxMessage original, List<MessageAttachment> attachments) throws MailboxException {
        Date internalDate = original.getInternalDate();
        long size = original.getFullContentOctets();
        Flags flags = original.createFlags();
        SharedByteArrayInputStream content = SimpleMailboxMessage.copyFullContent(original);
        int bodyStartOctet = Ints.checkedCast((long)(original.getFullContentOctets() - original.getBodyOctets()));
        PropertyBuilder pBuilder = new PropertyBuilder(original.getProperties());
        pBuilder.setTextualLineCount(original.getTextualLineCount());
        return new SimpleMailboxMessage(original.getMessageId(), internalDate, size, bodyStartOctet, (SharedInputStream)content, flags, pBuilder, mailboxId, attachments);
    }

    private static SharedByteArrayInputStream copyFullContent(MailboxMessage original) throws MailboxException {
        try {
            return new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)original.getFullContent()));
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Throwable)e);
        }
    }

    public SimpleMailboxMessage(MessageId messageId, Date internalDate, long size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder, MailboxId mailboxId, List<MessageAttachment> attachments) {
        super(new SimpleMessage(messageId, content, size, internalDate, propertyBuilder.getSubType(), propertyBuilder.getMediaType(), bodyStartOctet, propertyBuilder.getTextualLineCount(), propertyBuilder.toProperties(), attachments));
        this.setFlags(flags);
        this.mailboxId = mailboxId;
        this.userFlags = flags.getUserFlags();
    }

    public SimpleMailboxMessage(MessageId messageId, Date internalDate, long size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder, MailboxId mailboxId) {
        this(messageId, internalDate, size, bodyStartOctet, content, flags, propertyBuilder, mailboxId, (List<MessageAttachment>)ImmutableList.of());
    }

    @Override
    protected String[] createUserFlags() {
        return (String[])this.userFlags.clone();
    }

    @Override
    public MailboxId getMailboxId() {
        return this.mailboxId;
    }

    @Override
    public MessageUid getUid() {
        return this.uid;
    }

    @Override
    public boolean isAnswered() {
        return this.answered;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public boolean isDraft() {
        return this.draft;
    }

    @Override
    public boolean isFlagged() {
        return this.flagged;
    }

    @Override
    public boolean isRecent() {
        return this.recent;
    }

    @Override
    public boolean isSeen() {
        return this.seen;
    }

    @Override
    public long getModSeq() {
        return this.modSeq;
    }

    @Override
    public void setModSeq(long modSeq) {
        this.modSeq = modSeq;
    }

    @Override
    public void setUid(MessageUid uid) {
        this.uid = uid;
    }

    @Override
    public synchronized void setFlags(Flags flags) {
        this.answered = flags.contains(Flags.Flag.ANSWERED);
        this.deleted = flags.contains(Flags.Flag.DELETED);
        this.draft = flags.contains(Flags.Flag.DRAFT);
        this.flagged = flags.contains(Flags.Flag.FLAGGED);
        this.recent = flags.contains(Flags.Flag.RECENT);
        this.seen = flags.contains(Flags.Flag.SEEN);
        this.userFlags = flags.getUserFlags();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uid});
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleMailboxMessage) {
            SimpleMailboxMessage other = (SimpleMailboxMessage)obj;
            return Objects.equal((Object)this.uid, (Object)other.uid);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uid", (Object)this.uid).add("mailboxId", (Object)this.mailboxId).add("answered", this.answered).add("deleted", this.deleted).add("draft", this.draft).add("flagged", this.flagged).add("recent", this.recent).add("seen", this.seen).add("message", (Object)this.getMessage()).toString();
    }
}

