/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import org.apache.james.mailbox.model.Attachment;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.MessageWriter;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.field.ContentDispositionField;
import org.apache.james.mime4j.dom.field.ContentIdField;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageParser {
    private static final MimeConfig MIME_ENTITY_CONFIG = MimeConfig.custom().setMaxContentLen(-1L).setMaxHeaderCount(-1).setMaxHeaderLen(-1).setMaxHeaderCount(-1).setMaxLineLen(-1).build();
    private static final String TEXT_MEDIA_TYPE = "text";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_ID = "Content-ID";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final List<String> ATTACHMENT_CONTENT_DISPOSITIONS = ImmutableList.of((Object)"attachment".toLowerCase(Locale.US), (Object)"inline".toLowerCase(Locale.US));
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageParser.class);
    private static final Function<String, Optional<Cid>> STRING_TO_CID_FUNCTION = new Function<String, Optional<Cid>>(){

        public Optional<Cid> apply(String cid) {
            try {
                return Optional.of((Object)Cid.from((String)cid));
            }
            catch (IllegalArgumentException e) {
                return Optional.absent();
            }
        }
    };
    private static final Function<ContentIdField, Optional<Cid>> CONTENT_ID_FIELD_TO_OPTIONAL_CID_FUNCTION = new Function<ContentIdField, Optional<Cid>>(){

        public Optional<Cid> apply(ContentIdField field) {
            return (Optional)Optional.fromNullable((Object)field.getId()).transform(STRING_TO_CID_FUNCTION).or((Object)Optional.absent());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageAttachment> retrieveAttachments(InputStream fullContent) throws MimeException, IOException {
        DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
        defaultMessageBuilder.setMimeEntityConfig(MIME_ENTITY_CONFIG);
        Message message = defaultMessageBuilder.parseMessage(fullContent);
        Body body = message.getBody();
        try {
            Optional<ContentDispositionField> contentDisposition = this.readHeader((Entity)message, CONTENT_DISPOSITION, ContentDispositionField.class);
            if (this.isMessageWithOnlyOneAttachment(contentDisposition)) {
                ImmutableList immutableList = ImmutableList.of((Object)this.retrieveAttachment((MessageWriter)new DefaultMessageWriter(), (Entity)message));
                return immutableList;
            }
            if (body instanceof Multipart) {
                Multipart multipartBody = (Multipart)body;
                List<MessageAttachment> list = this.listAttachments(multipartBody, Context.fromSubType(multipartBody.getSubType()));
                return list;
            }
            ImmutableList immutableList = ImmutableList.of();
            return immutableList;
        }
        finally {
            body.dispose();
        }
    }

    private boolean isMessageWithOnlyOneAttachment(Optional<ContentDispositionField> contentDisposition) {
        return contentDisposition.isPresent() && ((ContentDispositionField)contentDisposition.get()).isAttachment();
    }

    private List<MessageAttachment> listAttachments(Multipart multipart, Context context) throws IOException {
        ImmutableList.Builder attachments = ImmutableList.builder();
        DefaultMessageWriter messageWriter = new DefaultMessageWriter();
        for (Entity entity : multipart.getBodyParts()) {
            if (this.isMultipart(entity)) {
                attachments.addAll(this.listAttachments((Multipart)entity.getBody(), Context.fromEntity(entity)));
                continue;
            }
            if (!this.isAttachment(entity, context)) continue;
            try {
                attachments.add((Object)this.retrieveAttachment((MessageWriter)messageWriter, entity));
            }
            catch (IllegalStateException e) {
                LOGGER.error("The attachment is not well-formed: " + e.getCause());
            }
            catch (IOException e) {
                LOGGER.error("There is error on retrieve attachment: " + e.getCause());
            }
        }
        return attachments.build();
    }

    private MessageAttachment retrieveAttachment(MessageWriter messageWriter, Entity entity) throws IOException {
        Optional<ContentTypeField> contentTypeField = this.getContentTypeField(entity);
        Optional<String> contentType = this.contentType(contentTypeField);
        Optional<String> name = this.name(contentTypeField);
        Optional<Cid> cid = this.cid(this.readHeader(entity, CONTENT_ID, ContentIdField.class));
        boolean isInline = this.isInline(this.readHeader(entity, CONTENT_DISPOSITION, ContentDispositionField.class));
        return MessageAttachment.builder().attachment(Attachment.builder().bytes(this.getBytes(messageWriter, entity.getBody())).type((String)contentType.or((Object)DEFAULT_CONTENT_TYPE)).build()).name((String)name.orNull()).cid((Cid)cid.orNull()).isInline(Boolean.valueOf(isInline)).build();
    }

    private <T extends ParsedField> Optional<T> readHeader(Entity entity, String headerName, Class<T> clazz) {
        return this.castField(entity.getHeader().getField(headerName), clazz);
    }

    private Optional<ContentTypeField> getContentTypeField(Entity entity) {
        return this.castField(entity.getHeader().getField(CONTENT_TYPE), ContentTypeField.class);
    }

    private <U extends ParsedField> Optional<U> castField(Field field, Class<U> clazz) {
        if (field == null || !clazz.isInstance(field)) {
            return Optional.absent();
        }
        return Optional.of((Object)((ParsedField)field));
    }

    private Optional<String> contentType(Optional<ContentTypeField> contentTypeField) {
        return (Optional)contentTypeField.transform((Function)new Function<ContentTypeField, Optional<String>>(){

            public Optional<String> apply(ContentTypeField field) {
                return Optional.fromNullable((Object)field.getMimeType());
            }
        }).or((Object)Optional.absent());
    }

    private Optional<String> name(Optional<ContentTypeField> contentTypeField) {
        return (Optional)contentTypeField.transform((Function)new Function<ContentTypeField, Optional<String>>(){

            public Optional<String> apply(ContentTypeField field) {
                return Optional.fromNullable((Object)field.getParameter("name")).transform((Function)new Function<String, String>(){

                    public String apply(String input) {
                        DecodeMonitor monitor = null;
                        return DecoderUtil.decodeEncodedWords((String)input, monitor);
                    }
                });
            }
        }).or((Object)Optional.absent());
    }

    private Optional<Cid> cid(Optional<ContentIdField> contentIdField) {
        return (Optional)contentIdField.transform(CONTENT_ID_FIELD_TO_OPTIONAL_CID_FUNCTION).or((Object)Optional.absent());
    }

    private boolean isMultipart(Entity entity) {
        return entity.isMultipart() && entity.getBody() instanceof Multipart;
    }

    private boolean isInline(Optional<ContentDispositionField> contentDispositionField) {
        return (Boolean)contentDispositionField.transform((Function)new Function<ContentDispositionField, Boolean>(){

            public Boolean apply(ContentDispositionField field) {
                return field.isInline();
            }
        }).or((Object)false);
    }

    private boolean isAttachment(Entity part, Context context) {
        if (context == Context.BODY && this.isTextPart(part)) {
            return false;
        }
        return (Boolean)Optional.fromNullable((Object)part.getDispositionType()).transform((Function)new Function<String, Boolean>(){

            public Boolean apply(String dispositionType) {
                return ATTACHMENT_CONTENT_DISPOSITIONS.contains(dispositionType.toLowerCase(Locale.US));
            }
        }).or((Object)false);
    }

    private boolean isTextPart(Entity part) {
        String mediaType;
        Optional<ContentTypeField> contentTypeField = this.getContentTypeField(part);
        return contentTypeField.isPresent() && (mediaType = ((ContentTypeField)contentTypeField.get()).getMediaType()) != null && mediaType.equals(TEXT_MEDIA_TYPE);
    }

    private byte[] getBytes(MessageWriter messageWriter, Body body) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        messageWriter.writeBody(body, (OutputStream)out);
        return out.toByteArray();
    }

    private static enum Context {
        BODY,
        OTHER;

        private static final String ALTERNATIVE_SUB_TYPE = "alternative";
        private static final String MULTIPART_ALTERNATIVE = "multipart/alternative";

        public static Context fromEntity(Entity entity) {
            if (Context.isMultipartAlternative(entity)) {
                return BODY;
            }
            return OTHER;
        }

        public static Context fromSubType(String subPart) {
            if (Context.isAlternative(subPart)) {
                return BODY;
            }
            return OTHER;
        }

        private static boolean isMultipartAlternative(Entity entity) {
            return entity.getMimeType().equalsIgnoreCase(MULTIPART_ALTERNATIVE);
        }

        private static boolean isAlternative(String subPart) {
            return subPart.equalsIgnoreCase(ALTERNATIVE_SUB_TYPE);
        }
    }
}

