/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model;

import javax.mail.Flags;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;

public class FlagsBuilder {
    public static Flags createFlags(MailboxMessage mailboxMessage, String[] userFlags) {
        Flags flags = new Flags();
        if (mailboxMessage.isAnswered()) {
            flags.add(Flags.Flag.ANSWERED);
        }
        if (mailboxMessage.isDeleted()) {
            flags.add(Flags.Flag.DELETED);
        }
        if (mailboxMessage.isDraft()) {
            flags.add(Flags.Flag.DRAFT);
        }
        if (mailboxMessage.isFlagged()) {
            flags.add(Flags.Flag.FLAGGED);
        }
        if (mailboxMessage.isRecent()) {
            flags.add(Flags.Flag.RECENT);
        }
        if (mailboxMessage.isSeen()) {
            flags.add(Flags.Flag.SEEN);
        }
        if (userFlags != null && userFlags.length > 0) {
            for (String userFlag : userFlags) {
                flags.add(userFlag);
            }
        }
        return flags;
    }
}

