/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.FlagsBuilder;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.Property;

public abstract class DelegatingMailboxMessage
implements MailboxMessage {
    private final Message message;

    protected DelegatingMailboxMessage(Message message) {
        this.message = message;
    }

    @Override
    public int compareTo(MailboxMessage other) {
        return this.getUid().compareTo(other.getUid());
    }

    @Override
    public final Flags createFlags() {
        return FlagsBuilder.createFlags(this, this.createUserFlags());
    }

    protected String[] createUserFlags() {
        return null;
    }

    @Override
    public long getBodyOctets() {
        return this.message.getBodyOctets();
    }

    @Override
    public long getFullContentOctets() {
        return this.message.getFullContentOctets();
    }

    @Override
    public Long getTextualLineCount() {
        return this.message.getTextualLineCount();
    }

    @Override
    public InputStream getHeaderContent() throws IOException {
        return this.message.getHeaderContent();
    }

    @Override
    public InputStream getFullContent() throws IOException {
        return this.message.getFullContent();
    }

    @Override
    public List<Property> getProperties() {
        return this.message.getProperties();
    }

    @Override
    public Date getInternalDate() {
        return this.message.getInternalDate();
    }

    @Override
    public InputStream getBodyContent() throws IOException {
        return this.message.getBodyContent();
    }

    @Override
    public String getMediaType() {
        return this.message.getMediaType();
    }

    @Override
    public String getSubType() {
        return this.message.getSubType();
    }

    @Override
    public MessageId getMessageId() {
        return this.message.getMessageId();
    }

    public Message getMessage() {
        return this.message;
    }

    @Override
    public List<MessageAttachment> getAttachments() {
        return this.message.getAttachments();
    }
}

