/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import org.apache.commons.lang.NotImplementedException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.StoreMailboxPath;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public abstract class AbstractLockingUidProvider
implements UidProvider {
    private final MailboxPathLocker locker;

    public AbstractLockingUidProvider(MailboxPathLocker locker) {
        this.locker = locker;
    }

    @Override
    public MessageUid nextUid(final MailboxSession session, final Mailbox mailbox) throws MailboxException {
        return (MessageUid)this.locker.executeWithLock(session, (MailboxPath)new StoreMailboxPath(mailbox), (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<MessageUid>(){

            public MessageUid execute() throws MailboxException {
                return AbstractLockingUidProvider.this.lockedNextUid(session, mailbox);
            }
        }, true);
    }

    protected abstract MessageUid lockedNextUid(MailboxSession var1, Mailbox var2) throws MailboxException;

    @Override
    public MessageUid nextUid(MailboxSession session, MailboxId mailboxId) throws MailboxException {
        throw new NotImplementedException();
    }
}

