/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import org.apache.commons.lang.NotImplementedException;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.StoreMailboxPath;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public abstract class AbstractLockingModSeqProvider
implements ModSeqProvider {
    private final MailboxPathLocker locker;

    public AbstractLockingModSeqProvider(MailboxPathLocker locker) {
        this.locker = locker;
    }

    @Override
    public long nextModSeq(final MailboxSession session, final Mailbox mailbox) throws MailboxException {
        return (Long)this.locker.executeWithLock(session, (MailboxPath)new StoreMailboxPath(mailbox), (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Long>(){

            public Long execute() throws MailboxException {
                return AbstractLockingModSeqProvider.this.lockedNextModSeq(session, mailbox);
            }
        }, true);
    }

    @Override
    public long nextModSeq(MailboxSession session, MailboxId mailboxId) throws MailboxException {
        throw new NotImplementedException();
    }

    protected abstract long lockedNextModSeq(MailboxSession var1, Mailbox var2) throws MailboxException;
}

