/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.json.event.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.store.SimpleMessageMetaData;
import org.apache.james.mailbox.store.json.event.dto.FlagsDataTransferObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageMetaDataDataTransferObject {
    @JsonProperty
    private long uid;
    @JsonProperty
    private long modseq;
    @JsonProperty
    private FlagsDataTransferObject flags;
    @JsonProperty
    private long size;
    @JsonProperty
    private String date;
    @JsonProperty
    private MessageId messageId;
    private static final Logger LOG = LoggerFactory.getLogger(MessageMetaDataDataTransferObject.class);
    private static final ThreadLocal<SimpleDateFormat> simpleDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        }
    };

    private static Date parse(String date) throws ParseException {
        if (date != null) {
            return simpleDateFormat.get().parse(date);
        }
        return null;
    }

    private static String format(Date date) {
        if (date != null) {
            return simpleDateFormat.get().format(date);
        }
        return null;
    }

    public MessageMetaDataDataTransferObject() {
    }

    public MessageMetaDataDataTransferObject(MessageMetaData metadata) {
        this.uid = metadata.getUid().asLong();
        this.modseq = metadata.getModSeq();
        this.flags = new FlagsDataTransferObject(metadata.getFlags());
        this.size = metadata.getSize();
        this.date = MessageMetaDataDataTransferObject.format(metadata.getInternalDate());
        this.messageId = metadata.getMessageId();
    }

    @JsonIgnore
    public SimpleMessageMetaData getMetadata() {
        try {
            return new SimpleMessageMetaData(MessageUid.of((long)this.uid), this.modseq, this.flags.getFlags(), this.size, MessageMetaDataDataTransferObject.parse(this.date), this.messageId);
        }
        catch (ParseException parseException) {
            LOG.error("Parse exception while parsing date while deserializing metadata upon event serialization. Using nowadays date instead.");
            return new SimpleMessageMetaData(MessageUid.of((long)this.uid), this.modseq, this.flags.getFlags(), this.size, new Date(), this.messageId);
        }
    }
}

