/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.json.event.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.store.SimpleMailboxSession;
import org.apache.james.mailbox.store.json.event.dto.LocaleDataTransferObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxSessionDataTransferObject {
    @JsonProperty
    private long sessionId;
    @JsonProperty
    private String username;
    @JsonProperty
    private List<String> sharedSpaces;
    @JsonProperty
    private String otherUserSpace;
    @JsonProperty
    private char separator;
    @JsonProperty
    private List<LocaleDataTransferObject> locales;
    @JsonProperty(value="r")
    private int sessionType;
    private static final Logger LOG = LoggerFactory.getLogger(MailboxSessionDataTransferObject.class);

    public MailboxSessionDataTransferObject() {
    }

    public MailboxSessionDataTransferObject(MailboxSession session) {
        this.username = session.getUser().getUserName();
        this.sharedSpaces = new ArrayList<String>(session.getSharedSpaces());
        this.otherUserSpace = session.getOtherUsersSpace();
        this.separator = session.getPathDelimiter();
        this.sessionType = this.extractSessionType(session);
        this.sessionId = session.getSessionId();
        this.locales = Lists.transform((List)session.getUser().getLocalePreferences(), (Function)new Function<Locale, LocaleDataTransferObject>(){

            public LocaleDataTransferObject apply(Locale locale) {
                return new LocaleDataTransferObject(locale);
            }
        });
    }

    @JsonIgnore
    public MailboxSession getMailboxSession() {
        return new SimpleMailboxSession(this.sessionId, this.username, "", LOG, this.retrieveLocales(), this.sharedSpaces, this.otherUserSpace, this.separator, this.retrieveSessionType());
    }

    private List<Locale> retrieveLocales() {
        if (this.locales != null) {
            return Lists.transform(this.locales, (Function)new Function<LocaleDataTransferObject, Locale>(){

                public Locale apply(LocaleDataTransferObject localeDataTransferObject) {
                    return localeDataTransferObject.getLocale();
                }
            });
        }
        return new ArrayList<Locale>();
    }

    private MailboxSession.SessionType retrieveSessionType() {
        switch (this.sessionType) {
            case 0: {
                return MailboxSession.SessionType.User;
            }
            case 1: {
                return MailboxSession.SessionType.System;
            }
        }
        LOG.warn("Unknown session type number while deserializing. Assuming user instead");
        return MailboxSession.SessionType.User;
    }

    private int extractSessionType(MailboxSession session) {
        switch (session.getType()) {
            case User: {
                return 0;
            }
            case System: {
                return 1;
            }
        }
        LOG.warn("Unknow session type while serializing mailbox session");
        return 0;
    }
}

