/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.json.event;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.json.SimpleMailboxACLJsonConverter;
import org.apache.james.mailbox.store.json.event.dto.MailboxDataTransferObject;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxIdDeserialisationException;
import org.apache.james.mailbox.store.mail.model.MailboxIdDeserializer;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailboxConverter.class);
    private final MailboxIdDeserializer mailboxIdDeserializer;

    public MailboxConverter(MailboxIdDeserializer mailboxIdDeserializer) {
        this.mailboxIdDeserializer = mailboxIdDeserializer;
    }

    public Mailbox retrieveMailbox(MailboxDataTransferObject mailboxDataTransferObject) {
        SimpleMailbox mailbox = new SimpleMailbox(new MailboxPath(mailboxDataTransferObject.getNamespace(), mailboxDataTransferObject.getUser(), mailboxDataTransferObject.getName()), mailboxDataTransferObject.getUidValidity());
        try {
            mailbox.setACL(SimpleMailboxACLJsonConverter.toACL(mailboxDataTransferObject.getSerializedACL()));
            mailbox.setMailboxId(this.mailboxIdDeserializer.deserialize(mailboxDataTransferObject.getSerializedMailboxId()));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to deserialize ACL", (Throwable)e);
        }
        catch (MailboxIdDeserialisationException e) {
            LOGGER.warn("Failed to deserialize mailbox ID", (Throwable)((Object)e));
        }
        return mailbox;
    }

    public MailboxDataTransferObject convertMailboxDataTransferObject(Mailbox mailbox) {
        return MailboxDataTransferObject.builder().serializedMailboxId(mailbox.getMailboxId().serialize()).namespace(mailbox.getNamespace()).user(mailbox.getUser()).name(mailbox.getName()).uidValidity(mailbox.getUidValidity()).serializedACL(this.getSerializedACL(mailbox)).build();
    }

    public MailboxDataTransferObject extractMailboxDataTransferObject(MailboxListener.Event event) {
        if (event instanceof EventFactory.MailboxAware) {
            return this.convertMailboxDataTransferObject(((EventFactory.MailboxAware)event).getMailbox());
        }
        throw new RuntimeException("Unsupported event class : " + event.getClass().getCanonicalName());
    }

    private String getSerializedACL(Mailbox mailbox) {
        try {
            return SimpleMailboxACLJsonConverter.toJson(mailbox.getACL());
        }
        catch (JsonProcessingException e) {
            return "{\"entries\":{}}";
        }
    }
}

