/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.json;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.SimpleMailboxACL;

public class SimpleMailboxACLJsonConverter {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String toJson(MailboxACL acl) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)acl);
    }

    public static MailboxACL toACL(String jsonACLString) throws IOException {
        return (MailboxACL)objectMapper.readValue(jsonACLString, SimpleMailboxACL.class);
    }

    static {
        SimpleModule module = new SimpleModule().addAbstractTypeMapping(MailboxACL.MailboxACLEntryKey.class, SimpleMailboxACL.SimpleMailboxACLEntryKey.class).addAbstractTypeMapping(MailboxACL.MailboxACLRights.class, SimpleMailboxACL.Rfc4314Rights.class).addKeyDeserializer(MailboxACL.MailboxACLEntryKey.class, (KeyDeserializer)new ACLKeyDeserializer());
        objectMapper.addMixIn(SimpleMailboxACL.Rfc4314Rights.class, Rfc4314RightsMixIn.class).registerModule((Module)module);
    }

    static class ACLKeyDeserializer
    extends KeyDeserializer {
        ACLKeyDeserializer() {
        }

        public Object deserializeKey(String key, DeserializationContext deserializationContext) throws IOException {
            return new SimpleMailboxACL.SimpleMailboxACLEntryKey(key);
        }
    }

    static interface Rfc4314RightsMixIn {
        @JsonValue
        public int getValue();
    }
}

