/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event.distributed;

import java.util.List;
import java.util.Set;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.event.EventDelivery;
import org.apache.james.mailbox.store.event.EventSerializer;
import org.apache.james.mailbox.store.event.MailboxListenerRegistry;
import org.apache.james.mailbox.store.event.SynchronousEventDelivery;
import org.apache.james.mailbox.store.event.distributed.DistributedDelegatingMailboxListener;
import org.apache.james.mailbox.store.event.distributed.MailboxPathRegister;
import org.apache.james.mailbox.store.publisher.MessageConsumer;
import org.apache.james.mailbox.store.publisher.Publisher;
import org.apache.james.mailbox.store.publisher.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredDelegatingMailboxListener
implements DistributedDelegatingMailboxListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredDelegatingMailboxListener.class);
    private final MailboxListenerRegistry mailboxListenerRegistry;
    private final MailboxPathRegister mailboxPathRegister;
    private final Publisher publisher;
    private final EventSerializer eventSerializer;
    private final EventDelivery eventDelivery;

    public RegisteredDelegatingMailboxListener(EventSerializer eventSerializer, Publisher publisher, MessageConsumer messageConsumer, MailboxPathRegister mailboxPathRegister, EventDelivery eventDelivery) throws Exception {
        this.eventSerializer = eventSerializer;
        this.publisher = publisher;
        this.mailboxPathRegister = mailboxPathRegister;
        this.mailboxListenerRegistry = new MailboxListenerRegistry();
        this.eventDelivery = eventDelivery;
        messageConsumer.setMessageReceiver(this);
        messageConsumer.init(mailboxPathRegister.getLocalTopic());
    }

    public RegisteredDelegatingMailboxListener(EventSerializer eventSerializer, Publisher publisher, MessageConsumer messageConsumer, MailboxPathRegister mailboxPathRegister) throws Exception {
        this(eventSerializer, publisher, messageConsumer, mailboxPathRegister, new SynchronousEventDelivery());
    }

    public MailboxListener.ListenerType getType() {
        return MailboxListener.ListenerType.ONCE;
    }

    public MailboxListener.ExecutionMode getExecutionMode() {
        return MailboxListener.ExecutionMode.SYNCHRONOUS;
    }

    public void addListener(MailboxPath path, MailboxListener listener, MailboxSession session) throws MailboxException {
        this.mailboxListenerRegistry.addListener(path, listener);
        this.mailboxPathRegister.register(path);
    }

    public void addGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        if (listener.getType().equals((Object)MailboxListener.ListenerType.EACH_NODE)) {
            throw new MailboxException("Attempt to register a global listener that need to be called on each node while using a non compatible delegating listeners");
        }
        this.mailboxListenerRegistry.addGlobalListener(listener);
    }

    public void removeListener(MailboxPath mailboxPath, MailboxListener listener, MailboxSession session) throws MailboxException {
        this.mailboxListenerRegistry.removeListener(mailboxPath, listener);
        this.mailboxPathRegister.unregister(mailboxPath);
    }

    public void removeGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        this.mailboxListenerRegistry.removeGlobalListener(listener);
    }

    public void event(MailboxListener.Event event) {
        try {
            this.deliverEventToOnceGlobalListeners(event);
            this.deliverToMailboxPathRegisteredListeners(event);
            this.sendToRemoteJames(event);
        }
        catch (Throwable t) {
            event.getSession().getLog().error("Error while delegating event " + event.getClass().getCanonicalName(), t);
        }
    }

    @Override
    public void receiveSerializedEvent(byte[] serializedEvent) {
        try {
            MailboxListener.Event event = this.eventSerializer.deSerializeEvent(serializedEvent);
            this.deliverToMailboxPathRegisteredListeners(event);
        }
        catch (Exception e) {
            LOGGER.error("Error while receiving serialized event", (Throwable)e);
        }
    }

    private void deliverToMailboxPathRegisteredListeners(MailboxListener.Event event) throws MailboxException {
        List<MailboxListener> listenerSnapshot = this.mailboxListenerRegistry.getLocalMailboxListeners(event.getMailboxPath());
        if (event instanceof MailboxListener.MailboxDeletion && listenerSnapshot.size() > 0) {
            this.mailboxListenerRegistry.deleteRegistryFor(event.getMailboxPath());
            this.mailboxPathRegister.doCompleteUnRegister(event.getMailboxPath());
        } else if (event instanceof MailboxListener.MailboxRenamed && listenerSnapshot.size() > 0) {
            MailboxListener.MailboxRenamed renamed = (MailboxListener.MailboxRenamed)event;
            this.mailboxListenerRegistry.handleRename(renamed.getMailboxPath(), renamed.getNewPath());
            this.mailboxPathRegister.doRename(renamed.getMailboxPath(), renamed.getNewPath());
        }
        for (MailboxListener listener : listenerSnapshot) {
            this.eventDelivery.deliver(listener, event);
        }
    }

    private void deliverEventToOnceGlobalListeners(MailboxListener.Event event) {
        for (MailboxListener mailboxListener : this.mailboxListenerRegistry.getGlobalListeners()) {
            if (mailboxListener.getType() != MailboxListener.ListenerType.ONCE) continue;
            this.eventDelivery.deliver(mailboxListener, event);
        }
    }

    private void sendToRemoteJames(MailboxListener.Event event) {
        Set<Topic> topics = this.mailboxPathRegister.getTopics(event.getMailboxPath());
        topics.remove(this.mailboxPathRegister.getLocalTopic());
        if (topics.size() > 0) {
            this.sendEventToRemotesJamesByTopic(event, topics);
        }
    }

    private void sendEventToRemotesJamesByTopic(MailboxListener.Event event, Set<Topic> topics) {
        byte[] serializedEvent;
        try {
            serializedEvent = this.eventSerializer.serializeEvent(event);
        }
        catch (Exception e) {
            event.getSession().getLog().error("Unable to serialize " + event.getClass().getCanonicalName(), (Throwable)e);
            return;
        }
        for (Topic topic : topics) {
            try {
                this.publisher.publish(topic, serializedEvent);
            }
            catch (Throwable t) {
                event.getSession().getLog().error("Unable to send serialized event to topic " + topic);
            }
        }
    }
}

