/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event.distributed;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.event.distributed.DistantMailboxPathRegisterMapper;
import org.apache.james.mailbox.store.event.distributed.MailboxPathRegister;
import org.apache.james.mailbox.store.publisher.Topic;

public class DistantMailboxPathRegister
implements MailboxPathRegister {
    private static final int DEFAULT_MAX_RETRY = 1000;
    private final ConcurrentHashMap<MailboxPath, Long> registeredMailboxPathCount;
    private final DistantMailboxPathRegisterMapper mapper;
    private final Topic topic;
    private final Timer timer;
    private final int maxRetry;
    private final long schedulerPeriodInS;

    public DistantMailboxPathRegister(DistantMailboxPathRegisterMapper mapper, long schedulerPeriodInS) {
        this(mapper, 1000, schedulerPeriodInS);
    }

    public DistantMailboxPathRegister(DistantMailboxPathRegisterMapper mapper, int maxRetry, long schedulerPeriodInS) {
        this.maxRetry = maxRetry;
        this.mapper = mapper;
        this.registeredMailboxPathCount = new ConcurrentHashMap();
        this.topic = new Topic(UUID.randomUUID().toString());
        this.timer = new Timer();
        this.schedulerPeriodInS = schedulerPeriodInS;
    }

    @PostConstruct
    public void init() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ImmutableSet snapshot = ImmutableSet.copyOf(DistantMailboxPathRegister.this.registeredMailboxPathCount.entrySet());
                for (Map.Entry entry : snapshot) {
                    if ((Long)entry.getValue() <= 0L) continue;
                    DistantMailboxPathRegister.this.mapper.doRegister((MailboxPath)entry.getKey(), DistantMailboxPathRegister.this.topic);
                }
            }
        }, 0L, this.schedulerPeriodInS * 1000L);
    }

    @PreDestroy
    public void destroy() {
        this.timer.cancel();
        this.timer.purge();
    }

    @Override
    public Set<Topic> getTopics(MailboxPath mailboxPath) {
        return this.mapper.getTopics(mailboxPath);
    }

    @Override
    public Topic getLocalTopic() {
        return this.topic;
    }

    @Override
    public void register(MailboxPath path) throws MailboxException {
        boolean success = false;
        for (int count = 0; count < this.maxRetry && !success; ++count) {
            success = this.tryRegister(path);
        }
        if (!success) {
            throw new MailboxException(this.maxRetry + " reached while trying to register " + path);
        }
    }

    @Override
    public void unregister(MailboxPath path) throws MailboxException {
        boolean success = false;
        for (int count = 0; count < this.maxRetry && !success; ++count) {
            success = this.tryUnregister(path);
        }
        if (!success) {
            throw new MailboxException(this.maxRetry + " reached while trying to unregister " + path);
        }
    }

    @Override
    public void doCompleteUnRegister(MailboxPath mailboxPath) {
        this.registeredMailboxPathCount.remove(mailboxPath);
        this.mapper.doUnRegister(mailboxPath, this.topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRename(MailboxPath oldPath, MailboxPath newPath) throws MailboxException {
        try {
            int count = 0;
            boolean success = false;
            while (count < this.maxRetry && !success) {
                success = this.tryCountTransfer(oldPath, newPath);
            }
            if (!success) {
                throw new MailboxException(this.maxRetry + " reached while trying to rename " + oldPath + " in " + newPath);
            }
        }
        finally {
            this.doCompleteUnRegister(oldPath);
        }
    }

    private boolean tryCountTransfer(MailboxPath oldPath, MailboxPath newPath) throws MailboxException {
        Long oldEntry = this.registeredMailboxPathCount.get(oldPath);
        if (oldEntry == null) {
            throw new MailboxException("Renamed entry does not exists");
        }
        Long entry = this.registeredMailboxPathCount.get(newPath);
        if (entry != null) {
            return this.registeredMailboxPathCount.replace(newPath, entry, oldEntry + entry);
        }
        if (this.registeredMailboxPathCount.putIfAbsent(newPath, oldEntry) == null) {
            this.mapper.doRegister(newPath, this.topic);
            return true;
        }
        return false;
    }

    private boolean tryRegister(MailboxPath path) {
        Long entry = this.registeredMailboxPathCount.get(path);
        Long newEntry = entry;
        if (newEntry == null) {
            newEntry = 0L;
        }
        Long l = newEntry;
        Long l2 = newEntry = Long.valueOf(newEntry + 1L);
        if (entry != null) {
            return this.registeredMailboxPathCount.replace(path, entry, newEntry);
        }
        if (this.registeredMailboxPathCount.putIfAbsent(path, newEntry) == null) {
            this.mapper.doRegister(path, this.topic);
            return true;
        }
        return false;
    }

    private boolean tryUnregister(MailboxPath path) throws MailboxException {
        Long entry = this.registeredMailboxPathCount.get(path);
        Long newEntry = entry;
        if (newEntry == null) {
            throw new MailboxException("Removing a non registered mailboxPath");
        }
        Long l = newEntry;
        Long l2 = newEntry = Long.valueOf(newEntry - 1L);
        if (newEntry != 0L) {
            return this.registeredMailboxPathCount.replace(path, entry, newEntry);
        }
        if (this.registeredMailboxPathCount.remove(path, entry)) {
            this.mapper.doUnRegister(path, this.topic);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    ConcurrentHashMap<MailboxPath, Long> getRegisteredMailboxPathCount() {
        return this.registeredMailboxPathCount;
    }
}

