/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event.distributed;

import java.util.List;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.event.EventDelivery;
import org.apache.james.mailbox.store.event.EventSerializer;
import org.apache.james.mailbox.store.event.MailboxListenerRegistry;
import org.apache.james.mailbox.store.event.SynchronousEventDelivery;
import org.apache.james.mailbox.store.event.distributed.DistributedDelegatingMailboxListener;
import org.apache.james.mailbox.store.publisher.MessageConsumer;
import org.apache.james.mailbox.store.publisher.Publisher;
import org.apache.james.mailbox.store.publisher.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastDelegatingMailboxListener
implements DistributedDelegatingMailboxListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BroadcastDelegatingMailboxListener.class);
    private final MailboxListenerRegistry mailboxListenerRegistry = new MailboxListenerRegistry();
    private final Publisher publisher;
    private final EventSerializer eventSerializer;
    private final Topic globalTopic;
    private final EventDelivery eventDelivery;

    public BroadcastDelegatingMailboxListener(Publisher publisher, MessageConsumer messageConsumer, EventSerializer eventSerializer, EventDelivery eventDelivery, String globalTopic) throws Exception {
        this.publisher = publisher;
        this.eventSerializer = eventSerializer;
        this.globalTopic = new Topic(globalTopic);
        this.eventDelivery = eventDelivery;
        messageConsumer.setMessageReceiver(this);
        messageConsumer.init(this.globalTopic);
    }

    public BroadcastDelegatingMailboxListener(Publisher publisher, MessageConsumer messageConsumer, EventSerializer eventSerializer, String globalTopic) throws Exception {
        this(publisher, messageConsumer, eventSerializer, new SynchronousEventDelivery(), globalTopic);
    }

    public MailboxListener.ListenerType getType() {
        return MailboxListener.ListenerType.ONCE;
    }

    public MailboxListener.ExecutionMode getExecutionMode() {
        return MailboxListener.ExecutionMode.SYNCHRONOUS;
    }

    public void addListener(MailboxPath mailboxPath, MailboxListener listener, MailboxSession session) throws MailboxException {
        this.mailboxListenerRegistry.addListener(mailboxPath, listener);
    }

    public void removeListener(MailboxPath mailboxPath, MailboxListener listener, MailboxSession session) throws MailboxException {
        this.mailboxListenerRegistry.removeListener(mailboxPath, listener);
    }

    public void addGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        this.mailboxListenerRegistry.addGlobalListener(listener);
    }

    public void removeGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        this.mailboxListenerRegistry.removeGlobalListener(listener);
    }

    public void event(MailboxListener.Event event) {
        this.deliverEventToGlobalListeners(event, MailboxListener.ListenerType.ONCE);
        try {
            this.publisher.publish(this.globalTopic, this.eventSerializer.serializeEvent(event));
        }
        catch (Throwable t) {
            event.getSession().getLog().error("Error while sending event to publisher", t);
        }
    }

    @Override
    public void receiveSerializedEvent(byte[] serializedEvent) {
        try {
            MailboxListener.Event event = this.eventSerializer.deSerializeEvent(serializedEvent);
            this.deliverToMailboxPathRegisteredListeners(event);
            this.deliverEventToGlobalListeners(event, MailboxListener.ListenerType.EACH_NODE);
        }
        catch (Exception e) {
            LOGGER.error("Error while receiving serialized event", (Throwable)e);
        }
    }

    private void deliverToMailboxPathRegisteredListeners(MailboxListener.Event event) {
        List<MailboxListener> listenerSnapshot = this.mailboxListenerRegistry.getLocalMailboxListeners(event.getMailboxPath());
        if (event instanceof MailboxListener.MailboxDeletion) {
            this.mailboxListenerRegistry.deleteRegistryFor(event.getMailboxPath());
        } else if (event instanceof MailboxListener.MailboxRenamed) {
            MailboxListener.MailboxRenamed renamed = (MailboxListener.MailboxRenamed)event;
            this.mailboxListenerRegistry.handleRename(renamed.getMailboxPath(), renamed.getNewPath());
        }
        for (MailboxListener listener : listenerSnapshot) {
            this.eventDelivery.deliver(listener, event);
        }
    }

    private void deliverEventToGlobalListeners(MailboxListener.Event event, MailboxListener.ListenerType type) {
        for (MailboxListener mailboxListener : this.mailboxListenerRegistry.getGlobalListeners()) {
            if (mailboxListener.getType() != type) continue;
            this.eventDelivery.deliver(mailboxListener, event);
        }
    }
}

