/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.store.event.AsynchronousEventDelivery;
import org.apache.james.mailbox.store.event.EventDelivery;
import org.apache.james.mailbox.store.event.SynchronousEventDelivery;

public class MixedEventDelivery
implements EventDelivery {
    private final AsynchronousEventDelivery asynchronousEventDelivery;
    private final SynchronousEventDelivery synchronousEventDelivery;

    public MixedEventDelivery(AsynchronousEventDelivery asynchronousEventDelivery, SynchronousEventDelivery synchronousEventDelivery) {
        this.asynchronousEventDelivery = asynchronousEventDelivery;
        this.synchronousEventDelivery = synchronousEventDelivery;
    }

    @Override
    public void deliver(MailboxListener mailboxListener, MailboxListener.Event event) {
        if (mailboxListener.getExecutionMode().equals((Object)MailboxListener.ExecutionMode.SYNCHRONOUS)) {
            this.synchronousEventDelivery.deliver(mailboxListener, event);
        } else {
            this.asynchronousEventDelivery.deliver(mailboxListener, event);
        }
    }

    public void stop() {
        this.asynchronousEventDelivery.stop();
    }
}

