/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;

public class MailboxListenerRegistry {
    private final Multimap<MailboxPath, MailboxListener> listeners;
    private final ConcurrentLinkedQueue<MailboxListener> globalListeners = new ConcurrentLinkedQueue();

    public MailboxListenerRegistry() {
        this.listeners = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    }

    public void addListener(MailboxPath path, MailboxListener listener) throws MailboxException {
        this.listeners.put((Object)path, (Object)listener);
    }

    public void addGlobalListener(MailboxListener listener) throws MailboxException {
        this.globalListeners.add(listener);
    }

    public void removeListener(MailboxPath mailboxPath, MailboxListener listener) throws MailboxException {
        this.listeners.remove((Object)mailboxPath, (Object)listener);
    }

    public void removeGlobalListener(MailboxListener listener) throws MailboxException {
        this.globalListeners.remove(listener);
    }

    public List<MailboxListener> getLocalMailboxListeners(MailboxPath path) {
        return ImmutableList.copyOf((Collection)this.listeners.get((Object)path));
    }

    public List<MailboxListener> getGlobalListeners() {
        return ImmutableList.copyOf(this.globalListeners);
    }

    public void deleteRegistryFor(MailboxPath path) {
        this.listeners.removeAll((Object)path);
    }

    public void handleRename(MailboxPath oldName, MailboxPath newName) {
        this.listeners.putAll((Object)newName, (Iterable)this.listeners.removeAll((Object)oldName));
    }
}

