/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.event.DelegatingMailboxListener;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class MailboxEventDispatcher {
    private final MailboxListener listener;
    private final EventFactory eventFactory;

    @VisibleForTesting
    public static MailboxEventDispatcher ofListener(MailboxListener mailboxListener) {
        return new MailboxEventDispatcher(mailboxListener, new EventFactory());
    }

    @Inject
    public MailboxEventDispatcher(DelegatingMailboxListener delegatingMailboxListener) {
        this(delegatingMailboxListener, new EventFactory());
    }

    private MailboxEventDispatcher(MailboxListener listener, EventFactory eventFactory) {
        this.listener = listener;
        this.eventFactory = eventFactory;
    }

    public void added(MailboxSession session, SortedMap<MessageUid, MessageMetaData> uids, Mailbox mailbox) {
        this.listener.event((MailboxListener.Event)this.eventFactory.added(session, uids, mailbox));
    }

    public void added(MailboxSession session, MessageMetaData messageMetaData, Mailbox mailbox) {
        ImmutableSortedMap metaDataMap = ImmutableSortedMap.naturalOrder().put((Object)messageMetaData.getUid(), (Object)messageMetaData).build();
        this.added(session, (SortedMap<MessageUid, MessageMetaData>)metaDataMap, mailbox);
    }

    public void expunged(MailboxSession session, Map<MessageUid, MessageMetaData> uids, Mailbox mailbox) {
        if (!uids.isEmpty()) {
            this.listener.event((MailboxListener.Event)this.eventFactory.expunged(session, uids, mailbox));
        }
    }

    public void expunged(MailboxSession session, MessageMetaData messageMetaData, Mailbox mailbox) {
        ImmutableMap metaDataMap = ImmutableMap.builder().put((Object)messageMetaData.getUid(), (Object)messageMetaData).build();
        this.expunged(session, (Map<MessageUid, MessageMetaData>)metaDataMap, mailbox);
    }

    public void flagsUpdated(MailboxSession session, List<MessageUid> uids, Mailbox mailbox, List<UpdatedFlags> uflags) {
        if (!uids.isEmpty()) {
            this.listener.event((MailboxListener.Event)this.eventFactory.flagsUpdated(session, uids, mailbox, uflags));
        }
    }

    public void flagsUpdated(MailboxSession session, MessageUid uid, Mailbox mailbox, UpdatedFlags uflags) {
        this.flagsUpdated(session, (List<MessageUid>)ImmutableList.of((Object)uid), mailbox, (List<UpdatedFlags>)ImmutableList.of((Object)uflags));
    }

    public void mailboxRenamed(MailboxSession session, MailboxPath from, Mailbox to) {
        this.listener.event((MailboxListener.Event)this.eventFactory.mailboxRenamed(session, from, to));
    }

    public void mailboxDeleted(MailboxSession session, Mailbox mailbox) {
        this.listener.event((MailboxListener.Event)this.eventFactory.mailboxDeleted(session, mailbox));
    }

    public void mailboxAdded(MailboxSession session, Mailbox mailbox) {
        this.listener.event((MailboxListener.Event)this.eventFactory.mailboxAdded(session, mailbox));
    }
}

