/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import java.util.List;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxAnnotationListener
implements MailboxListener {
    private static final Logger logger = LoggerFactory.getLogger(MailboxAnnotationListener.class);
    private MailboxSessionMapperFactory mailboxSessionMapperFactory;

    public MailboxAnnotationListener(MailboxSessionMapperFactory mailboxSessionMapperFactory) {
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
    }

    public MailboxListener.ListenerType getType() {
        return MailboxListener.ListenerType.EACH_NODE;
    }

    public MailboxListener.ExecutionMode getExecutionMode() {
        return MailboxListener.ExecutionMode.SYNCHRONOUS;
    }

    public void event(MailboxListener.Event event) {
        if (event instanceof EventFactory.MailboxDeletionImpl) {
            try {
                AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(event.getSession());
                MailboxId mailboxId = ((EventFactory.MailboxDeletionImpl)event).getMailbox().getMailboxId();
                this.deleteRelatedAnnotations(mailboxId, annotationMapper);
            }
            catch (MailboxException e) {
                logger.error("Unable to look up AnnotationMapper", (Throwable)e);
            }
        }
    }

    private void deleteRelatedAnnotations(MailboxId mailboxId, AnnotationMapper annotationMapper) {
        List<MailboxAnnotation> annotations = annotationMapper.getAllAnnotations(mailboxId);
        for (MailboxAnnotation annotation : annotations) {
            try {
                annotationMapper.deleteAnnotation(mailboxId, annotation.getKey());
            }
            catch (Exception e) {
                logger.error("Unable to delete annotation {0} cause {1}", (Object)annotation.getKey(), (Object)e.getMessage());
            }
        }
    }
}

