/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.StoreMailboxPath;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class EventFactory {
    public MailboxListener.Added added(MailboxSession session, SortedMap<MessageUid, MessageMetaData> uids, Mailbox mailbox) {
        return new AddedImpl(session, mailbox, uids);
    }

    public MailboxListener.Expunged expunged(MailboxSession session, Map<MessageUid, MessageMetaData> uids, Mailbox mailbox) {
        return new ExpungedImpl(session, mailbox, uids);
    }

    public MailboxListener.FlagsUpdated flagsUpdated(MailboxSession session, List<MessageUid> uids, Mailbox mailbox, List<UpdatedFlags> uflags) {
        return new FlagsUpdatedImpl(session, mailbox, uids, uflags);
    }

    public MailboxListener.MailboxRenamed mailboxRenamed(MailboxSession session, MailboxPath from, Mailbox to) {
        return new MailboxRenamedEventImpl(session, from, to);
    }

    public MailboxListener.MailboxDeletion mailboxDeleted(MailboxSession session, Mailbox mailbox) {
        return new MailboxDeletionImpl(session, mailbox);
    }

    public MailboxListener.MailboxAdded mailboxAdded(MailboxSession session, Mailbox mailbox) {
        return new MailboxAddedImpl(session, mailbox);
    }

    public final class MailboxRenamedEventImpl
    extends MailboxListener.MailboxRenamed
    implements MailboxAware {
        private final MailboxPath newPath;
        private final Mailbox newMailbox;

        public MailboxRenamedEventImpl(MailboxSession session, MailboxPath oldPath, Mailbox newMailbox) {
            super(session, oldPath);
            this.newPath = new StoreMailboxPath(newMailbox);
            this.newMailbox = newMailbox;
        }

        public MailboxPath getNewPath() {
            return this.newPath;
        }

        @Override
        public Mailbox getMailbox() {
            return this.newMailbox;
        }
    }

    public final class MailboxAddedImpl
    extends MailboxListener.MailboxAdded
    implements MailboxAware {
        private final Mailbox mailbox;

        public MailboxAddedImpl(MailboxSession session, Mailbox mailbox) {
            super(session, (MailboxPath)new StoreMailboxPath(mailbox));
            this.mailbox = mailbox;
        }

        @Override
        public Mailbox getMailbox() {
            return this.mailbox;
        }
    }

    public final class MailboxDeletionImpl
    extends MailboxListener.MailboxDeletion
    implements MailboxAware {
        private final Mailbox mailbox;

        public MailboxDeletionImpl(MailboxSession session, Mailbox mailbox) {
            super(session, (MailboxPath)new StoreMailboxPath(mailbox));
            this.mailbox = mailbox;
        }

        @Override
        public Mailbox getMailbox() {
            return this.mailbox;
        }
    }

    public final class FlagsUpdatedImpl
    extends MailboxListener.FlagsUpdated
    implements MailboxAware {
        private final List<MessageUid> uids;
        private final Mailbox mailbox;
        private final List<UpdatedFlags> uFlags;

        public FlagsUpdatedImpl(MailboxSession session, Mailbox mailbox, List<MessageUid> uids, List<UpdatedFlags> uFlags) {
            super(session, (MailboxPath)new StoreMailboxPath(mailbox));
            this.uids = ImmutableList.copyOf(uids);
            this.uFlags = ImmutableList.copyOf(uFlags);
            this.mailbox = mailbox;
        }

        public List<MessageUid> getUids() {
            return this.uids;
        }

        public List<UpdatedFlags> getUpdatedFlags() {
            return this.uFlags;
        }

        @Override
        public Mailbox getMailbox() {
            return this.mailbox;
        }
    }

    public final class ExpungedImpl
    extends MailboxListener.Expunged
    implements MailboxAware {
        private final Map<MessageUid, MessageMetaData> uids;
        private final Mailbox mailbox;

        public ExpungedImpl(MailboxSession session, Mailbox mailbox, Map<MessageUid, MessageMetaData> uids) {
            super(session, (MailboxPath)new StoreMailboxPath(mailbox));
            this.uids = ImmutableMap.copyOf(uids);
            this.mailbox = mailbox;
        }

        public List<MessageUid> getUids() {
            return ImmutableList.copyOf(this.uids.keySet());
        }

        public MessageMetaData getMetaData(MessageUid uid) {
            return this.uids.get(uid);
        }

        @Override
        public Mailbox getMailbox() {
            return this.mailbox;
        }
    }

    public final class AddedImpl
    extends MailboxListener.Added
    implements MailboxAware {
        private final Map<MessageUid, MessageMetaData> added;
        private final Mailbox mailbox;

        public AddedImpl(MailboxSession session, Mailbox mailbox, SortedMap<MessageUid, MessageMetaData> uids) {
            super(session, (MailboxPath)new StoreMailboxPath(mailbox));
            this.added = ImmutableMap.copyOf(uids);
            this.mailbox = mailbox;
        }

        public List<MessageUid> getUids() {
            return ImmutableList.copyOf(this.added.keySet());
        }

        public MessageMetaData getMetaData(MessageUid uid) {
            return this.added.get(uid);
        }

        @Override
        public Mailbox getMailbox() {
            return this.mailbox;
        }
    }

    public static interface MailboxAware {
        public Mailbox getMailbox();
    }
}

