/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.event.DelegatingMailboxListener;
import org.apache.james.mailbox.store.event.EventDelivery;
import org.apache.james.mailbox.store.event.MailboxListenerRegistry;
import org.apache.james.mailbox.store.event.SynchronousEventDelivery;

public class DefaultDelegatingMailboxListener
implements DelegatingMailboxListener {
    private final MailboxListenerRegistry registry = new MailboxListenerRegistry();
    private final EventDelivery eventDelivery;

    public MailboxListener.ListenerType getType() {
        return MailboxListener.ListenerType.EACH_NODE;
    }

    public MailboxListener.ExecutionMode getExecutionMode() {
        return MailboxListener.ExecutionMode.SYNCHRONOUS;
    }

    public DefaultDelegatingMailboxListener() {
        this(new SynchronousEventDelivery());
    }

    @Inject
    public DefaultDelegatingMailboxListener(EventDelivery eventDelivery) {
        this.eventDelivery = eventDelivery;
    }

    public void addListener(MailboxPath path, MailboxListener listener, MailboxSession session) throws MailboxException {
        if (listener.getType() != MailboxListener.ListenerType.MAILBOX) {
            throw new MailboxException(listener.getClass().getCanonicalName() + " registred on specific MAILBOX operation while its listener type was " + listener.getType());
        }
        this.registry.addListener(path, listener);
    }

    public void addGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        if (listener.getType() != MailboxListener.ListenerType.EACH_NODE && listener.getType() != MailboxListener.ListenerType.ONCE) {
            throw new MailboxException(listener.getClass().getCanonicalName() + " registered on global event dispatching while its listener type was " + listener.getType());
        }
        this.registry.addGlobalListener(listener);
    }

    public void removeListener(MailboxPath mailboxPath, MailboxListener listener, MailboxSession session) throws MailboxException {
        this.registry.removeListener(mailboxPath, listener);
    }

    public void removeGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        this.registry.removeGlobalListener(listener);
    }

    public void event(MailboxListener.Event event) {
        List<MailboxListener> listenerSnapshot = this.registry.getLocalMailboxListeners(event.getMailboxPath());
        if (event instanceof MailboxListener.MailboxDeletion && listenerSnapshot.size() > 0) {
            this.registry.deleteRegistryFor(event.getMailboxPath());
        } else if (event instanceof MailboxListener.MailboxRenamed && listenerSnapshot.size() > 0) {
            MailboxListener.MailboxRenamed renamed = (MailboxListener.MailboxRenamed)event;
            this.registry.handleRename(renamed.getMailboxPath(), renamed.getNewPath());
        }
        this.deliverEventToMailboxListeners(event, listenerSnapshot);
        this.deliverEventToGlobalListeners(event);
    }

    protected void deliverEventToMailboxListeners(MailboxListener.Event event, Collection<MailboxListener> listenerSnapshot) {
        for (MailboxListener listener : listenerSnapshot) {
            this.eventDelivery.deliver(listener, event);
        }
    }

    protected void deliverEventToGlobalListeners(MailboxListener.Event event) {
        for (MailboxListener mailboxListener : this.registry.getGlobalListeners()) {
            this.eventDelivery.deliver(mailboxListener, event);
        }
    }

    public MailboxListenerRegistry getRegistry() {
        return this.registry;
    }
}

