/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.RequestAware;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.mailbox.store.user.model.Subscription;
import org.apache.james.mailbox.store.user.model.impl.SimpleSubscription;

public class StoreSubscriptionManager
implements SubscriptionManager {
    private static final int INITIAL_SIZE = 32;
    protected SubscriptionMapperFactory mapperFactory;

    @Inject
    public StoreSubscriptionManager(SubscriptionMapperFactory mapperFactory) {
        this.mapperFactory = mapperFactory;
    }

    public void subscribe(final MailboxSession session, final String mailbox) throws SubscriptionException {
        final SubscriptionMapper mapper = this.mapperFactory.getSubscriptionMapper(session);
        try {
            mapper.execute(new Mapper.VoidTransaction(){

                @Override
                public void runVoid() throws MailboxException {
                    Subscription subscription = mapper.findMailboxSubscriptionForUser(session.getUser().getUserName(), mailbox);
                    if (subscription == null) {
                        Subscription newSubscription = StoreSubscriptionManager.this.createSubscription(session, mailbox);
                        mapper.save(newSubscription);
                    }
                }
            });
        }
        catch (MailboxException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
    }

    protected Subscription createSubscription(MailboxSession session, String mailbox) {
        return new SimpleSubscription(session.getUser().getUserName(), mailbox);
    }

    public Collection<String> subscriptions(MailboxSession session) throws SubscriptionException {
        SubscriptionMapper mapper = this.mapperFactory.getSubscriptionMapper(session);
        List<Subscription> subscriptions = mapper.findSubscriptionsForUser(session.getUser().getUserName());
        HashSet<String> results = new HashSet<String>(32);
        for (Subscription subscription : subscriptions) {
            results.add(subscription.getMailbox());
        }
        return results;
    }

    public void unsubscribe(final MailboxSession session, final String mailbox) throws SubscriptionException {
        final SubscriptionMapper mapper = this.mapperFactory.getSubscriptionMapper(session);
        try {
            mapper.execute(new Mapper.VoidTransaction(){

                @Override
                public void runVoid() throws MailboxException {
                    Subscription subscription = mapper.findMailboxSubscriptionForUser(session.getUser().getUserName(), mailbox);
                    if (subscription != null) {
                        mapper.delete(subscription);
                    }
                }
            });
        }
        catch (MailboxException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
    }

    public void endProcessingRequest(MailboxSession session) {
        if (this.mapperFactory instanceof RequestAware) {
            ((RequestAware)this.mapperFactory).endProcessingRequest(session);
        }
    }

    public void startProcessingRequest(MailboxSession session) {
    }
}

