/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedFileInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.ReadOnlyException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.Attachment;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.SimpleMailboxACL;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.BatchSizes;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.GroupFolderResolver;
import org.apache.james.mailbox.store.MailboxMetaData;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MoveResult;
import org.apache.james.mailbox.store.SimpleMessageMetaData;
import org.apache.james.mailbox.store.StoreMailboxPath;
import org.apache.james.mailbox.store.StoreMessageResultIterator;
import org.apache.james.mailbox.store.event.MailboxEventDispatcher;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.mailbox.store.quota.QuotaChecker;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.streaming.BodyOffsetInputStream;
import org.apache.james.mailbox.store.streaming.CountingInputStream;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.message.DefaultBodyDescriptorBuilder;
import org.apache.james.mime4j.message.HeaderImpl;
import org.apache.james.mime4j.message.MaximalBodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.stream.RecursionMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMessageManager
implements MessageManager {
    private static final MimeConfig MIME_ENTITY_CONFIG = MimeConfig.custom().setMaxContentLen(-1L).setMaxHeaderCount(-1).setMaxHeaderLen(-1).setMaxHeaderCount(-1).setMaxLineLen(-1).build();
    protected static final Flags MINIMAL_PERMANET_FLAGS = new Flags();
    private static final Logger LOG;
    private final Mailbox mailbox;
    private final MailboxEventDispatcher dispatcher;
    private final MailboxSessionMapperFactory mapperFactory;
    private final MessageSearchIndex index;
    private final MailboxACLResolver aclResolver;
    private final GroupMembershipResolver groupMembershipResolver;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final MailboxPathLocker locker;
    private final MessageParser messageParser;
    private final MessageId.Factory messageIdFactory;
    private BatchSizes batchSizes = BatchSizes.defaultValues();

    private static final Predicate<MessageAttachment> NOT_INLINE_ATTACHMENT() {
        return new Predicate<MessageAttachment>(){

            public boolean apply(MessageAttachment input) {
                return !input.isInlinedWithCid();
            }
        };
    }

    public StoreMessageManager(MailboxSessionMapperFactory mapperFactory, MessageSearchIndex index, MailboxEventDispatcher dispatcher, MailboxPathLocker locker, Mailbox mailbox, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, MessageParser messageParser, MessageId.Factory messageIdFactory, BatchSizes batchSizes) throws MailboxException {
        this.mailbox = mailbox;
        this.dispatcher = dispatcher;
        this.mapperFactory = mapperFactory;
        this.index = index;
        this.locker = locker;
        this.aclResolver = aclResolver;
        this.groupMembershipResolver = groupMembershipResolver;
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
        this.messageParser = messageParser;
        this.messageIdFactory = messageIdFactory;
        this.batchSizes = batchSizes;
    }

    protected MessageId.Factory getMessageIdFactory() {
        return this.messageIdFactory;
    }

    protected MailboxPathLocker getLocker() {
        return this.locker;
    }

    protected MailboxEventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Mailbox getMailboxEntity() throws MailboxException {
        return this.mailbox;
    }

    protected Flags getPermanentFlags(MailboxSession session) {
        return new Flags(MINIMAL_PERMANET_FLAGS);
    }

    public MailboxCounters getMailboxCounters(MailboxSession mailboxSession) throws MailboxException {
        return this.mapperFactory.createMessageMapper(mailboxSession).getMailboxCounters(this.mailbox);
    }

    protected Flags getSharedPermanentFlags(MailboxSession session) {
        return this.getPermanentFlags(session);
    }

    public boolean isModSeqPermanent(MailboxSession session) {
        return true;
    }

    public Iterator<MessageUid> expunge(MessageRange set, MailboxSession mailboxSession) throws MailboxException {
        if (!this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath(), mailboxSession.getPathDelimiter());
        }
        Map<MessageUid, MessageMetaData> uids = this.deleteMarkedInMailbox(set, mailboxSession);
        this.dispatcher.expunged(mailboxSession, uids, this.getMailboxEntity());
        return uids.keySet().iterator();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ComposedMessageId appendMessage(InputStream msgIn, Date internalDate, final MailboxSession mailboxSession, boolean isRecent, Flags flagsToBeSet) throws MailboxException {
        ComposedMessageId composedMessageId;
        File file = null;
        TeeInputStream tmpMsgIn = null;
        BodyOffsetInputStream bIn = null;
        FileOutputStream out = null;
        SharedFileInputStream contentIn = null;
        if (!this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath(), mailboxSession.getPathDelimiter());
        }
        try {
            Flags flags;
            String boundary;
            String subType;
            String mediaType;
            file = File.createTempFile("imap", ".msg");
            out = new FileOutputStream(file);
            tmpMsgIn = new TeeInputStream(msgIn, (OutputStream)out);
            bIn = new BodyOffsetInputStream((InputStream)tmpMsgIn);
            MimeConfig config = MIME_ENTITY_CONFIG;
            MimeTokenStream parser = new MimeTokenStream(config, (BodyDescriptorBuilder)new DefaultBodyDescriptorBuilder());
            parser.setRecursionMode(RecursionMode.M_NO_RECURSE);
            parser.parse((InputStream)bIn);
            HeaderImpl header = new HeaderImpl();
            EntityState next = parser.next();
            while (next != EntityState.T_BODY && next != EntityState.T_END_OF_STREAM && next != EntityState.T_START_MULTIPART) {
                if (next == EntityState.T_FIELD) {
                    header.addField(parser.getField());
                }
                next = parser.next();
            }
            MaximalBodyDescriptor descriptor = (MaximalBodyDescriptor)parser.getBodyDescriptor();
            PropertyBuilder propertyBuilder = new PropertyBuilder();
            String mediaTypeFromHeader = descriptor.getMediaType();
            if (mediaTypeFromHeader == null) {
                mediaType = "text";
                subType = "plain";
            } else {
                mediaType = mediaTypeFromHeader;
                subType = descriptor.getSubType();
            }
            propertyBuilder.setMediaType(mediaType);
            propertyBuilder.setSubType(subType);
            propertyBuilder.setContentID(descriptor.getContentId());
            propertyBuilder.setContentDescription(descriptor.getContentDescription());
            propertyBuilder.setContentLocation(descriptor.getContentLocation());
            propertyBuilder.setContentMD5(descriptor.getContentMD5Raw());
            propertyBuilder.setContentTransferEncoding(descriptor.getTransferEncoding());
            propertyBuilder.setContentLanguage(descriptor.getContentLanguage());
            propertyBuilder.setContentDispositionType(descriptor.getContentDispositionType());
            propertyBuilder.setContentDispositionParameters(descriptor.getContentDispositionParameters());
            propertyBuilder.setContentTypeParameters(descriptor.getContentTypeParameters());
            String codeset = descriptor.getCharset();
            if (codeset == null) {
                if ("TEXT".equalsIgnoreCase(mediaType)) {
                    propertyBuilder.setCharset("us-ascii");
                }
            } else {
                propertyBuilder.setCharset(codeset);
            }
            if ((boundary = descriptor.getBoundary()) != null) {
                propertyBuilder.setBoundary(boundary);
            }
            if ("text".equalsIgnoreCase(mediaType)) {
                CountingInputStream bodyStream = new CountingInputStream(parser.getInputStream());
                bodyStream.readAll();
                long lines = bodyStream.getLineCount();
                bodyStream.close();
                next = parser.next();
                if (next == EntityState.T_EPILOGUE) {
                    CountingInputStream epilogueStream = new CountingInputStream(parser.getInputStream());
                    epilogueStream.readAll();
                    lines += (long)epilogueStream.getLineCount();
                    epilogueStream.close();
                }
                propertyBuilder.setTextualLineCount(lines);
            }
            if (flagsToBeSet == null) {
                flags = new Flags();
            } else {
                flags = flagsToBeSet;
                this.trimFlags(flags, mailboxSession);
            }
            if (isRecent) {
                flags.add(Flags.Flag.RECENT);
            }
            if (internalDate == null) {
                internalDate = new Date();
            }
            byte[] discard = new byte[4096];
            while (tmpMsgIn.read(discard) != -1) {
            }
            int bodyStartOctet = (int)bIn.getBodyStartOffset();
            if (bodyStartOctet == -1) {
                bodyStartOctet = 0;
            }
            contentIn = new SharedFileInputStream(file);
            int size = (int)file.length();
            final List<MessageAttachment> attachments = this.extractAttachments(contentIn);
            propertyBuilder.setHasAttachment(this.hasNonInlinedAttachment(attachments));
            final MailboxMessage message = this.createMessage(internalDate, size, bodyStartOctet, (SharedInputStream)contentIn, flags, propertyBuilder, attachments);
            new QuotaChecker(this.quotaManager, this.quotaRootResolver, this.mailbox).tryAddition(1L, size);
            composedMessageId = (ComposedMessageId)this.locker.executeWithLock(mailboxSession, this.getMailboxPath(), (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<ComposedMessageId>(){

                public ComposedMessageId execute() throws MailboxException {
                    MessageMetaData data = StoreMessageManager.this.appendMessageToStore(message, attachments, mailboxSession);
                    TreeMap<MessageUid, MessageMetaData> uids = new TreeMap<MessageUid, MessageMetaData>();
                    MessageUid messageUid = data.getUid();
                    MailboxId mailboxId = StoreMessageManager.this.getMailboxEntity().getMailboxId();
                    uids.put(messageUid, data);
                    StoreMessageManager.this.dispatcher.added(mailboxSession, uids, StoreMessageManager.this.getMailboxEntity());
                    return new ComposedMessageId(mailboxId, data.getMessageId(), messageUid);
                }
            }, true);
        }
        catch (IOException e) {
            try {
                throw new MailboxException("Unable to parse message", (Throwable)e);
                catch (MimeException e2) {
                    throw new MailboxException("Unable to parse message", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bIn);
                IOUtils.closeQuietly(tmpMsgIn);
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(contentIn);
                if (file == null || !file.delete()) {
                    // empty if block
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bIn);
        IOUtils.closeQuietly((InputStream)tmpMsgIn);
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)contentIn);
        if (file == null || !file.delete()) {
            // empty if block
        }
        return composedMessageId;
    }

    private boolean hasNonInlinedAttachment(List<MessageAttachment> attachments) {
        return FluentIterable.from(attachments).anyMatch(StoreMessageManager.NOT_INLINE_ATTACHMENT());
    }

    private List<MessageAttachment> extractAttachments(SharedFileInputStream contentIn) {
        try {
            return this.messageParser.retrieveAttachments((InputStream)contentIn);
        }
        catch (Exception e) {
            LOG.warn("Error while parsing mail's attachments: " + e.getMessage(), (Throwable)e);
            return ImmutableList.of();
        }
    }

    protected MailboxMessage createMessage(Date internalDate, int size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder, List<MessageAttachment> attachments) throws MailboxException {
        return new SimpleMailboxMessage(this.messageIdFactory.generate(), internalDate, size, bodyStartOctet, content, flags, propertyBuilder, this.getMailboxEntity().getMailboxId(), attachments);
    }

    public boolean isWriteable(MailboxSession session) throws MailboxException {
        return this.aclResolver.isReadWrite(this.myRights(session), this.getSharedPermanentFlags(session));
    }

    public MessageManager.MetaData getMetaData(boolean resetRecent, MailboxSession mailboxSession, MessageManager.MetaData.FetchGroup fetchGroup) throws MailboxException {
        ArrayList<MessageUid> recent;
        MessageUid firstUnseen;
        long messageCount;
        long unseenCount;
        Flags permanentFlags = this.getPermanentFlags(mailboxSession);
        long uidValidity = this.getMailboxEntity().getUidValidity();
        MessageUid uidNext = (MessageUid)this.mapperFactory.getMessageMapper(mailboxSession).getLastUid(this.mailbox).transform((Function)new Function<MessageUid, MessageUid>(){

            public MessageUid apply(MessageUid input) {
                return input.next();
            }
        }).or((Object)MessageUid.MIN_VALUE);
        long highestModSeq = this.mapperFactory.getMessageMapper(mailboxSession).getHighestModSeq(this.mailbox);
        switch (fetchGroup) {
            case UNSEEN_COUNT: {
                unseenCount = this.countUnseenMessagesInMailbox(mailboxSession);
                messageCount = this.getMessageCount(mailboxSession);
                firstUnseen = null;
                recent = this.recent(resetRecent, mailboxSession);
                break;
            }
            case FIRST_UNSEEN: {
                firstUnseen = this.findFirstUnseenMessageUid(mailboxSession);
                messageCount = this.getMessageCount(mailboxSession);
                unseenCount = 0L;
                recent = this.recent(resetRecent, mailboxSession);
                break;
            }
            case NO_UNSEEN: {
                firstUnseen = null;
                unseenCount = 0L;
                messageCount = this.getMessageCount(mailboxSession);
                recent = this.recent(resetRecent, mailboxSession);
                break;
            }
            default: {
                firstUnseen = null;
                unseenCount = 0L;
                messageCount = -1L;
                if (resetRecent) {
                    this.recent(resetRecent, mailboxSession);
                }
                recent = new ArrayList();
            }
        }
        MailboxACL resolvedAcl = this.getResolvedMailboxACL(mailboxSession);
        return new MailboxMetaData(recent, permanentFlags, uidValidity, uidNext, highestModSeq, messageCount, unseenCount, firstUnseen, this.isWriteable(mailboxSession), this.isModSeqPermanent(mailboxSession), resolvedAcl);
    }

    private void trimFlags(Flags flags, MailboxSession session) {
        Flags.Flag[] systemFlags;
        Flags permFlags = this.getPermanentFlags(session);
        for (Flags.Flag f : systemFlags = flags.getSystemFlags()) {
            if (f == Flags.Flag.RECENT || permFlags.contains(f)) continue;
            flags.remove(f);
        }
        if (!permFlags.contains(Flags.Flag.USER)) {
            String[] uFlags;
            for (String uFlag : uFlags = flags.getUserFlags()) {
                if (permFlags.contains(uFlag)) continue;
                flags.remove(uFlag);
            }
        }
    }

    public Map<MessageUid, Flags> setFlags(final Flags flags, final MessageManager.FlagsUpdateMode flagsUpdateMode, final MessageRange set, MailboxSession mailboxSession) throws MailboxException {
        if (!this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath(), mailboxSession.getPathDelimiter());
        }
        TreeMap<MessageUid, Flags> newFlagsByUid = new TreeMap<MessageUid, Flags>();
        this.trimFlags(flags, mailboxSession);
        final MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        Iterator<UpdatedFlags> it = messageMapper.execute(new Mapper.Transaction<Iterator<UpdatedFlags>>(){

            @Override
            public Iterator<UpdatedFlags> run() throws MailboxException {
                return messageMapper.updateFlags(StoreMessageManager.this.getMailboxEntity(), new FlagsUpdateCalculator(flags, flagsUpdateMode), set);
            }
        });
        TreeMap<MessageUid, UpdatedFlags> uFlags = new TreeMap<MessageUid, UpdatedFlags>();
        while (it.hasNext()) {
            UpdatedFlags flag = it.next();
            newFlagsByUid.put(flag.getUid(), flag.getNewFlags());
            uFlags.put(flag.getUid(), flag);
        }
        this.dispatcher.flagsUpdated(mailboxSession, new ArrayList<MessageUid>(uFlags.keySet()), this.getMailboxEntity(), new ArrayList<UpdatedFlags>(uFlags.values()));
        return newFlagsByUid;
    }

    public List<MessageRange> copyTo(final MessageRange set, final StoreMessageManager toMailbox, final MailboxSession session) throws MailboxException {
        if (!toMailbox.isWriteable(session)) {
            throw new ReadOnlyException((MailboxPath)new StoreMailboxPath(toMailbox.getMailboxEntity()), session.getPathDelimiter());
        }
        return (List)this.locker.executeWithLock(session, (MailboxPath)new StoreMailboxPath(toMailbox.getMailboxEntity()), (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<List<MessageRange>>(){

            public List<MessageRange> execute() throws MailboxException {
                SortedMap copiedUids = StoreMessageManager.this.copy(set, toMailbox, session);
                StoreMessageManager.this.dispatcher.added(session, copiedUids, toMailbox.getMailboxEntity());
                return MessageRange.toRanges(new ArrayList(copiedUids.keySet()));
            }
        }, true);
    }

    public List<MessageRange> moveTo(final MessageRange set, final StoreMessageManager toMailbox, final MailboxSession session) throws MailboxException {
        if (!this.isWriteable(session)) {
            throw new ReadOnlyException(this.getMailboxPath(), session.getPathDelimiter());
        }
        if (!toMailbox.isWriteable(session)) {
            throw new ReadOnlyException((MailboxPath)new StoreMailboxPath(toMailbox.getMailboxEntity()), session.getPathDelimiter());
        }
        return (List)this.locker.executeWithLock(session, (MailboxPath)new StoreMailboxPath(toMailbox.getMailboxEntity()), (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<List<MessageRange>>(){

            public List<MessageRange> execute() throws MailboxException {
                SortedMap movedUids = StoreMessageManager.this.move(set, toMailbox, session);
                StoreMessageManager.this.dispatcher.added(session, movedUids, toMailbox.getMailboxEntity());
                return MessageRange.toRanges(new ArrayList(movedUids.keySet()));
            }
        }, true);
    }

    protected MessageMetaData appendMessageToStore(final MailboxMessage message, final List<MessageAttachment> messageAttachments, MailboxSession session) throws MailboxException {
        final MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        final AttachmentMapper attachmentMapper = this.mapperFactory.getAttachmentMapper(session);
        return this.mapperFactory.getMessageMapper(session).execute(new Mapper.Transaction<MessageMetaData>(){

            @Override
            public MessageMetaData run() throws MailboxException {
                ImmutableList.Builder attachments = ImmutableList.builder();
                for (MessageAttachment attachment : messageAttachments) {
                    attachments.add((Object)attachment.getAttachment());
                }
                attachmentMapper.storeAttachments((Collection<Attachment>)attachments.build());
                return messageMapper.add(StoreMessageManager.this.getMailboxEntity(), message);
            }
        });
    }

    public long getMessageCount(MailboxSession mailboxSession) throws MailboxException {
        return this.mapperFactory.getMessageMapper(mailboxSession).countMessagesInMailbox(this.getMailboxEntity());
    }

    public MessageResultIterator getMessages(MessageRange set, MessageResult.FetchGroup fetchGroup, MailboxSession mailboxSession) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        return new StoreMessageResultIterator(messageMapper, this.mailbox, set, this.batchSizes, fetchGroup);
    }

    protected List<MessageUid> recent(final boolean reset, MailboxSession mailboxSession) throws MailboxException {
        if (reset && !this.isWriteable(mailboxSession)) {
            throw new ReadOnlyException(this.getMailboxPath(), mailboxSession.getPathDelimiter());
        }
        final MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        return messageMapper.execute(new Mapper.Transaction<List<MessageUid>>(){

            @Override
            public List<MessageUid> run() throws MailboxException {
                List<MessageUid> members = messageMapper.findRecentMessageUidsInMailbox(StoreMessageManager.this.getMailboxEntity());
                List ranges = MessageRange.toRanges(members);
                for (MessageRange range : ranges) {
                    if (!reset) continue;
                    messageMapper.updateFlags(StoreMessageManager.this.getMailboxEntity(), new FlagsUpdateCalculator(new Flags(Flags.Flag.RECENT), MessageManager.FlagsUpdateMode.REMOVE), range);
                }
                return members;
            }
        });
    }

    protected Map<MessageUid, MessageMetaData> deleteMarkedInMailbox(final MessageRange range, MailboxSession session) throws MailboxException {
        final MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.execute(new Mapper.Transaction<Map<MessageUid, MessageMetaData>>(){

            @Override
            public Map<MessageUid, MessageMetaData> run() throws MailboxException {
                return messageMapper.expungeMarkedForDeletionInMailbox(StoreMessageManager.this.getMailboxEntity(), range);
            }
        });
    }

    public Iterator<MessageUid> search(SearchQuery query, MailboxSession mailboxSession) throws MailboxException {
        if (query.equals((Object)new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()}))) {
            return this.listAllMessageUids(mailboxSession);
        }
        return this.index.search(mailboxSession, this.getMailboxEntity(), query);
    }

    private Iterator<MessageMetaData> copy(Iterator<MailboxMessage> originalRows, MailboxSession session) throws MailboxException {
        ArrayList<MessageMetaData> copiedRows = new ArrayList<MessageMetaData>();
        final MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        QuotaChecker quotaChecker = new QuotaChecker(this.quotaManager, this.quotaRootResolver, this.mailbox);
        while (originalRows.hasNext()) {
            final MailboxMessage originalMessage = originalRows.next();
            quotaChecker.tryAddition(1L, originalMessage.getFullContentOctets());
            MessageMetaData data = messageMapper.execute(new Mapper.Transaction<MessageMetaData>(){

                @Override
                public MessageMetaData run() throws MailboxException {
                    return messageMapper.copy(StoreMessageManager.this.getMailboxEntity(), originalMessage);
                }
            });
            copiedRows.add(data);
        }
        return copiedRows.iterator();
    }

    private MoveResult move(Iterator<MailboxMessage> originalRows, MailboxSession session) throws MailboxException {
        ArrayList<MessageMetaData> movedRows = new ArrayList<MessageMetaData>();
        ArrayList<SimpleMessageMetaData> originalRowsCopy = new ArrayList<SimpleMessageMetaData>();
        final MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        while (originalRows.hasNext()) {
            final MailboxMessage originalMessage = originalRows.next();
            originalRowsCopy.add(new SimpleMessageMetaData(originalMessage));
            MessageMetaData data = messageMapper.execute(new Mapper.Transaction<MessageMetaData>(){

                @Override
                public MessageMetaData run() throws MailboxException {
                    return messageMapper.move(StoreMessageManager.this.getMailboxEntity(), originalMessage);
                }
            });
            movedRows.add(data);
        }
        return new MoveResult(movedRows.iterator(), originalRowsCopy.iterator());
    }

    private SortedMap<MessageUid, MessageMetaData> copy(MessageRange set, StoreMessageManager to, MailboxSession session) throws MailboxException {
        Iterator<MailboxMessage> originalRows = this.retrieveOriginalRows(set, session);
        return this.collectMetadata(to.copy(originalRows, session));
    }

    private SortedMap<MessageUid, MessageMetaData> move(MessageRange set, StoreMessageManager to, MailboxSession session) throws MailboxException {
        Iterator<MailboxMessage> originalRows = this.retrieveOriginalRows(set, session);
        MoveResult moveResult = to.move(originalRows, session);
        this.dispatcher.expunged(session, this.collectMetadata(moveResult.getOriginalMessages()), this.getMailboxEntity());
        return this.collectMetadata(moveResult.getMovedMessages());
    }

    private Iterator<MailboxMessage> retrieveOriginalRows(MessageRange set, MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.findInMailbox(this.mailbox, set, MessageMapper.FetchType.Full, -1);
    }

    private SortedMap<MessageUid, MessageMetaData> collectMetadata(Iterator<MessageMetaData> ids) {
        TreeMap<MessageUid, MessageMetaData> copiedMessages = new TreeMap<MessageUid, MessageMetaData>();
        while (ids.hasNext()) {
            MessageMetaData data = ids.next();
            copiedMessages.put(data.getUid(), data);
        }
        return copiedMessages;
    }

    protected long countUnseenMessagesInMailbox(MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.countUnseenMessagesInMailbox(this.getMailboxEntity());
    }

    protected MessageUid findFirstUnseenMessageUid(MailboxSession session) throws MailboxException {
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.findFirstUnseenMessageUid(this.getMailboxEntity());
    }

    private MailboxACL.MailboxACLRights myRights(MailboxSession session) throws MailboxException {
        MailboxSession.User user = session.getUser();
        if (user != null) {
            return this.aclResolver.resolveRights(user.getUserName(), this.groupMembershipResolver, this.mailbox.getACL(), this.mailbox.getUser(), new GroupFolderResolver(session).isGroupFolder(this.mailbox));
        }
        return SimpleMailboxACL.NO_RIGHTS;
    }

    protected MailboxACL getResolvedMailboxACL(MailboxSession mailboxSession) throws UnsupportedRightException {
        return this.aclResolver.applyGlobalACL(this.mailbox.getACL(), new GroupFolderResolver(mailboxSession).isGroupFolder(this.mailbox));
    }

    public MailboxId getId() {
        return this.mailbox.getMailboxId();
    }

    public MailboxPath getMailboxPath() throws MailboxException {
        return new StoreMailboxPath(this.getMailboxEntity());
    }

    public Flags getApplicableFlags(MailboxSession session) throws MailboxException {
        return this.mapperFactory.getMessageMapper(session).getApplicableFlag(this.mailbox);
    }

    private Iterator<MessageUid> listAllMessageUids(MailboxSession session) throws MailboxException {
        final MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
        return messageMapper.execute(new Mapper.Transaction<Iterator<MessageUid>>(){

            @Override
            public Iterator<MessageUid> run() throws MailboxException {
                return messageMapper.listAllMessageUids(StoreMessageManager.this.mailbox);
            }
        });
    }

    static {
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.ANSWERED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.DELETED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.DRAFT);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.FLAGGED);
        MINIMAL_PERMANET_FLAGS.add(Flags.Flag.SEEN);
        LOG = LoggerFactory.getLogger(StoreMessageManager.class);
    }
}

