/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.SimpleMessageMetaData;
import org.apache.james.mailbox.store.event.MailboxEventDispatcher;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.mailbox.store.quota.QuotaChecker;

public class StoreMessageIdManager
implements MessageIdManager {
    private static final Function<MailboxMessage, MetadataWithMailboxId> EXTRACT_METADATA_FUNCTION = new Function<MailboxMessage, MetadataWithMailboxId>(){

        public MetadataWithMailboxId apply(MailboxMessage mailboxMessage) {
            return new MetadataWithMailboxId(new SimpleMessageMetaData(mailboxMessage), mailboxMessage.getMailboxId());
        }
    };
    private static final Function<MailboxMessage, MailboxId> EXTRACT_MAILBOX_ID_FUNCTION = new Function<MailboxMessage, MailboxId>(){

        public MailboxId apply(MailboxMessage input) {
            return input.getMailboxId();
        }
    };
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final MailboxEventDispatcher dispatcher;
    private final MessageId.Factory messageIdFactory;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;

    @Inject
    public StoreMessageIdManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, MailboxEventDispatcher dispatcher, MessageId.Factory messageIdFactory, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver) {
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.dispatcher = dispatcher;
        this.messageIdFactory = messageIdFactory;
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    public void setFlags(Flags newState, MessageManager.FlagsUpdateMode replace, MessageId messageId, List<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        this.allowOnMailboxSession(mailboxIds, mailboxSession, mailboxMapper);
        Map<MailboxId, UpdatedFlags> updatedFlags = messageIdMapper.setFlags(messageId, mailboxIds, newState, replace);
        for (Map.Entry<MailboxId, UpdatedFlags> entry : updatedFlags.entrySet()) {
            this.dispatchFlagsChange(mailboxSession, entry.getKey(), entry.getValue());
        }
    }

    public List<MessageResult> getMessages(List<MessageId> messageIds, MessageResult.FetchGroup fetchGroup, MailboxSession mailboxSession) throws MailboxException {
        try {
            MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
            MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
            List<MailboxMessage> messageList = messageIdMapper.find(messageIds, MessageMapper.FetchType.Full);
            ImmutableSet mailboxIds = FluentIterable.from(messageList).transform(EXTRACT_MAILBOX_ID_FUNCTION).toSet();
            ImmutableSet allowedMailboxIds = FluentIterable.from((Iterable)mailboxIds).filter(this.mailboxBelongsToUser(mailboxSession, mailboxMapper)).toSet();
            return FluentIterable.from(messageList).filter(this.inMailboxes((Collection<MailboxId>)allowedMailboxIds)).transform(this.messageResultConverter(fetchGroup)).toList();
        }
        catch (WrappedException wrappedException) {
            throw wrappedException.unwrap();
        }
    }

    public void delete(MessageId messageId, List<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        this.allowOnMailboxSession(mailboxIds, mailboxSession, mailboxMapper);
        FluentIterable metadatasWithMailbox = FluentIterable.from(messageIdMapper.find((List<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.Metadata)).filter(this.inMailboxes(mailboxIds)).transform(EXTRACT_METADATA_FUNCTION);
        messageIdMapper.delete(messageId, mailboxIds);
        for (MetadataWithMailboxId metadataWithMailboxId : metadatasWithMailbox) {
            this.dispatcher.expunged(mailboxSession, metadataWithMailboxId.messageMetaData, mailboxMapper.findMailboxById(metadataWithMailboxId.mailboxId));
        }
    }

    public void setInMailboxes(MessageId messageId, List<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        this.allowOnMailboxSession(mailboxIds, mailboxSession, mailboxMapper);
        ImmutableList mailboxMessages = FluentIterable.from(messageIdMapper.find((List<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.Full)).filter(this.belongsToUser(mailboxSession, mailboxMapper)).toList();
        if (!mailboxMessages.isEmpty()) {
            ImmutableSet currentMailboxes = FluentIterable.from((Iterable)mailboxMessages).transform(EXTRACT_MAILBOX_ID_FUNCTION).toSet();
            HashSet targetMailboxes = Sets.newHashSet(mailboxIds);
            ImmutableList mailboxesToRemove = ImmutableList.copyOf((Collection)Sets.difference((Set)currentMailboxes, (Set)targetMailboxes));
            Sets.SetView mailboxesToAdd = Sets.difference((Set)targetMailboxes, (Set)currentMailboxes);
            MailboxMessage mailboxMessage = (MailboxMessage)mailboxMessages.get(0);
            this.validateQuota((Collection<MailboxId>)mailboxesToAdd, (Collection<MailboxId>)mailboxesToRemove, mailboxSession, mailboxMessage);
            if (!mailboxesToAdd.isEmpty()) {
                this.addMessageToMailboxes(messageIdMapper, mailboxMessage, (Sets.SetView<MailboxId>)mailboxesToAdd, mailboxSession);
            }
            if (!mailboxesToRemove.isEmpty()) {
                this.delete(messageId, (List<MailboxId>)mailboxesToRemove, mailboxSession);
            }
        }
    }

    protected MailboxMessage createMessage(Date internalDate, int size, int bodyStartOctet, SharedInputStream content, Flags flags, PropertyBuilder propertyBuilder, List<MessageAttachment> attachments, MailboxId mailboxId) throws MailboxException {
        return new SimpleMailboxMessage(this.messageIdFactory.generate(), internalDate, size, bodyStartOctet, content, flags, propertyBuilder, mailboxId, attachments);
    }

    private void dispatchFlagsChange(MailboxSession mailboxSession, MailboxId mailboxId, UpdatedFlags updatedFlags) throws MailboxException {
        if (updatedFlags.flagsChanged()) {
            Mailbox mailbox = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession).findMailboxById(mailboxId);
            this.dispatcher.flagsUpdated(mailboxSession, updatedFlags.getUid(), mailbox, updatedFlags);
        }
    }

    private void validateQuota(Collection<MailboxId> mailboxIdsToBeAdded, Collection<MailboxId> mailboxIdsToBeRemove, MailboxSession mailboxSession, MailboxMessage mailboxMessage) throws MailboxException {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        Map<QuotaRoot, Integer> messageCountByQuotaRoot = this.buildMapQuotaRoot(mailboxIdsToBeAdded, mailboxIdsToBeRemove, mailboxMapper);
        for (Map.Entry<QuotaRoot, Integer> entry : messageCountByQuotaRoot.entrySet()) {
            if (entry.getValue() <= 0) continue;
            new QuotaChecker(this.quotaManager.getMessageQuota(entry.getKey()), this.quotaManager.getStorageQuota(entry.getKey()), entry.getKey()).tryAddition(entry.getValue().intValue(), mailboxMessage.getFullContentOctets());
        }
    }

    private Map<QuotaRoot, Integer> buildMapQuotaRoot(Collection<MailboxId> mailboxIdsToBeAdded, Collection<MailboxId> mailboxIdsToBeRemove, MailboxMapper mailboxMapper) throws MailboxException {
        int currentCount;
        QuotaRoot quotaRoot;
        HashMap<QuotaRoot, Integer> messageCountByQuotaRoot = new HashMap<QuotaRoot, Integer>();
        for (MailboxId mailboxId : mailboxIdsToBeAdded) {
            quotaRoot = this.retrieveQuotaRoot(mailboxMapper, mailboxId);
            currentCount = (Integer)Optional.fromNullable(messageCountByQuotaRoot.get(quotaRoot)).or((Object)0);
            messageCountByQuotaRoot.put(quotaRoot, currentCount + 1);
        }
        for (MailboxId mailboxId : mailboxIdsToBeRemove) {
            quotaRoot = this.retrieveQuotaRoot(mailboxMapper, mailboxId);
            currentCount = (Integer)Optional.fromNullable(messageCountByQuotaRoot.get(quotaRoot)).or((Object)0);
            messageCountByQuotaRoot.put(quotaRoot, currentCount - 1);
        }
        return messageCountByQuotaRoot;
    }

    private QuotaRoot retrieveQuotaRoot(MailboxMapper mailboxMapper, MailboxId mailboxId) throws MailboxException {
        Mailbox mailbox = mailboxMapper.findMailboxById(mailboxId);
        return this.quotaRootResolver.getQuotaRoot(mailbox.generateAssociatedPath());
    }

    private void addMessageToMailboxes(MessageIdMapper messageIdMapper, MailboxMessage mailboxMessage, Sets.SetView<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        for (MailboxId mailboxId : mailboxIds) {
            SimpleMailboxMessage copy = SimpleMailboxMessage.copy(mailboxId, mailboxMessage);
            MessageMetaData metaData = this.save(mailboxSession, messageIdMapper, copy);
            this.dispatcher.added(mailboxSession, metaData, mailboxMapper.findMailboxById(mailboxId));
        }
    }

    private MessageMetaData save(MailboxSession mailboxSession, MessageIdMapper messageIdMapper, MailboxMessage mailboxMessage) throws MailboxException {
        long modSeq = this.mailboxSessionMapperFactory.getModSeqProvider().nextModSeq(mailboxSession, mailboxMessage.getMailboxId());
        MessageUid uid = this.mailboxSessionMapperFactory.getUidProvider().nextUid(mailboxSession, mailboxMessage.getMailboxId());
        mailboxMessage.setModSeq(modSeq);
        mailboxMessage.setUid(uid);
        messageIdMapper.save(mailboxMessage);
        return new SimpleMessageMetaData(uid, modSeq, mailboxMessage.createFlags(), mailboxMessage.getFullContentOctets(), mailboxMessage.getInternalDate(), mailboxMessage.getMessageId());
    }

    private Function<MailboxMessage, MessageResult> messageResultConverter(final MessageResult.FetchGroup fetchGroup) {
        return new Function<MailboxMessage, MessageResult>(){

            public MessageResult apply(MailboxMessage input) {
                try {
                    return ResultUtils.loadMessageResult(input, fetchGroup);
                }
                catch (MailboxException e) {
                    throw new WrappedException(e);
                }
            }
        };
    }

    private Predicate<MailboxMessage> inMailboxes(final Collection<MailboxId> mailboxIds) {
        return new Predicate<MailboxMessage>(){

            public boolean apply(MailboxMessage mailboxMessage) {
                return mailboxIds.contains(mailboxMessage.getMailboxId());
            }
        };
    }

    private Predicate<MailboxMessage> belongsToUser(final MailboxSession mailboxSession, final MailboxMapper mailboxMapper) {
        return new Predicate<MailboxMessage>(){

            public boolean apply(MailboxMessage input) {
                try {
                    Mailbox currentMailbox = mailboxMapper.findMailboxById(input.getMailboxId());
                    return StoreMessageIdManager.this.belongsToCurrentUser(currentMailbox, mailboxSession);
                }
                catch (MailboxException e) {
                    return false;
                }
            }
        };
    }

    private Predicate<MailboxId> mailboxBelongsToUser(final MailboxSession mailboxSession, final MailboxMapper mailboxMapper) {
        return new Predicate<MailboxId>(){

            public boolean apply(MailboxId mailboxId) {
                try {
                    Mailbox currentMailbox = mailboxMapper.findMailboxById(mailboxId);
                    return StoreMessageIdManager.this.belongsToCurrentUser(currentMailbox, mailboxSession);
                }
                catch (MailboxException e) {
                    return false;
                }
            }
        };
    }

    private void allowOnMailboxSession(List<MailboxId> mailboxIds, MailboxSession mailboxSession, MailboxMapper mailboxMapper) throws MailboxNotFoundException {
        Optional mailboxForbidden = FluentIterable.from(mailboxIds).firstMatch(this.isMailboxOfOtherUser(mailboxSession, mailboxMapper)).or(Optional.absent());
        if (mailboxForbidden.isPresent()) {
            throw new MailboxNotFoundException("Mailbox with Id " + mailboxForbidden.get() + " does not belong to session");
        }
    }

    private Predicate<MailboxId> isMailboxOfOtherUser(final MailboxSession mailboxSession, final MailboxMapper mailboxMapper) {
        return new Predicate<MailboxId>(){

            public boolean apply(MailboxId mailboxId) {
                try {
                    return !StoreMessageIdManager.this.belongsToCurrentUser(mailboxMapper.findMailboxById(mailboxId), mailboxSession);
                }
                catch (MailboxException e) {
                    return true;
                }
            }
        };
    }

    private boolean belongsToCurrentUser(Mailbox mailbox, MailboxSession session) {
        return session.getUser().isSameUser(mailbox.getUser());
    }

    private static class WrappedException
    extends RuntimeException {
        private final MailboxException cause;

        public WrappedException(MailboxException cause) {
            this.cause = cause;
        }

        public MailboxException unwrap() throws MailboxException {
            throw this.cause;
        }
    }

    private static class MetadataWithMailboxId {
        private final MessageMetaData messageMetaData;
        private final MailboxId mailboxId;

        public MetadataWithMailboxId(MessageMetaData messageMetaData, MailboxId mailboxId) {
            this.messageMetaData = messageMetaData;
            this.mailboxId = mailboxId;
        }
    }
}

