/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MailboxSessionIdGenerator;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.RequestAware;
import org.apache.james.mailbox.StandardMailboxMetaDataComparator;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.exception.AnnotationException;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.NotAdminException;
import org.apache.james.mailbox.exception.UserDoesNotExistException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MailboxQuery;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SimpleMailboxACL;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.BatchSizes;
import org.apache.james.mailbox.store.GroupFolderResolver;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MessageBatcher;
import org.apache.james.mailbox.store.RandomMailboxSessionIdGenerator;
import org.apache.james.mailbox.store.SimpleMailboxMetaData;
import org.apache.james.mailbox.store.SimpleMailboxSession;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.event.DefaultDelegatingMailboxListener;
import org.apache.james.mailbox.store.event.DelegatingMailboxListener;
import org.apache.james.mailbox.store.event.MailboxAnnotationListener;
import org.apache.james.mailbox.store.event.MailboxEventDispatcher;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailbox;
import org.apache.james.mailbox.store.quota.DefaultQuotaRootResolver;
import org.apache.james.mailbox.store.quota.NoQuotaManager;
import org.apache.james.mailbox.store.quota.QuotaUpdater;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.SimpleMessageSearchIndex;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.slf4j.Logger;

public class StoreMailboxManager
implements MailboxManager {
    public static final char SQL_WILDCARD_CHAR = '%';
    private MailboxEventDispatcher dispatcher;
    private DelegatingMailboxListener delegatingListener;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final Authenticator authenticator;
    private Authorizator authorizator;
    private final MailboxACLResolver aclResolver;
    private final GroupMembershipResolver groupMembershipResolver;
    private static final Random RANDOM = new Random();
    private MessageBatcher copyBatcher;
    private MessageBatcher moveBatcher;
    private final MailboxPathLocker locker;
    private MessageSearchIndex index;
    private MailboxSessionIdGenerator idGenerator;
    private QuotaManager quotaManager;
    private QuotaRootResolver quotaRootResolver;
    private QuotaUpdater quotaUpdater;
    private BatchSizes batchSizes = BatchSizes.defaultValues();
    private final MessageParser messageParser;
    private final MessageId.Factory messageIdFactory;
    private final int limitOfAnnotations;
    private final int limitAnnotationSize;

    @Inject
    public StoreMailboxManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxPathLocker locker, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MessageParser messageParser, MessageId.Factory messageIdFactory, MailboxEventDispatcher mailboxEventDispatcher, DelegatingMailboxListener delegatingListener) {
        this(mailboxSessionMapperFactory, authenticator, authorizator, locker, aclResolver, groupMembershipResolver, messageParser, messageIdFactory, 10, 1024, mailboxEventDispatcher, delegatingListener);
    }

    public StoreMailboxManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxPathLocker locker, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MessageParser messageParser, MessageId.Factory messageIdFactory) {
        this(mailboxSessionMapperFactory, authenticator, authorizator, locker, aclResolver, groupMembershipResolver, messageParser, messageIdFactory, 10, 1024);
    }

    public StoreMailboxManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MessageParser messageParser, MessageId.Factory messageIdFactory, int limitOfAnnotations, int limitAnnotationSize) {
        this(mailboxSessionMapperFactory, authenticator, authorizator, (MailboxPathLocker)new JVMMailboxPathLocker(), aclResolver, groupMembershipResolver, messageParser, messageIdFactory, limitOfAnnotations, limitAnnotationSize);
    }

    public StoreMailboxManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxPathLocker locker, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MessageParser messageParser, MessageId.Factory messageIdFactory, int limitOfAnnotations, int limitAnnotationSize) {
        this(mailboxSessionMapperFactory, authenticator, authorizator, locker, aclResolver, groupMembershipResolver, messageParser, messageIdFactory, limitOfAnnotations, limitAnnotationSize, null, null);
    }

    public StoreMailboxManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxPathLocker locker, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MessageParser messageParser, MessageId.Factory messageIdFactory, int limitOfAnnotations, int limitAnnotationSize, MailboxEventDispatcher mailboxEventDispatcher, DelegatingMailboxListener delegatingListener) {
        this.authenticator = authenticator;
        this.authorizator = authorizator;
        this.locker = locker;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.aclResolver = aclResolver;
        this.groupMembershipResolver = groupMembershipResolver;
        this.messageParser = messageParser;
        this.messageIdFactory = messageIdFactory;
        this.limitOfAnnotations = limitOfAnnotations;
        this.limitAnnotationSize = limitAnnotationSize;
        this.delegatingListener = delegatingListener;
        this.dispatcher = mailboxEventDispatcher;
    }

    protected MessageId.Factory getMessageIdFactory() {
        return this.messageIdFactory;
    }

    public void setMailboxSessionIdGenerator(MailboxSessionIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void setQuotaManager(QuotaManager quotaManager) {
        this.quotaManager = quotaManager;
    }

    public void setQuotaRootResolver(QuotaRootResolver quotaRootResolver) {
        this.quotaRootResolver = quotaRootResolver;
    }

    public void setQuotaUpdater(QuotaUpdater quotaUpdater) {
        this.quotaUpdater = quotaUpdater;
    }

    public void setCopyBatchSize(BatchSizes batchSizes) {
        this.copyBatcher = new MessageBatcher(batchSizes.getCopyBatchSize());
    }

    public void setMoveBatchSize(BatchSizes batchSizes) {
        this.moveBatcher = new MessageBatcher(batchSizes.getMoveBatchSize());
    }

    public void setBatchSizes(BatchSizes batchSizes) {
        this.batchSizes = batchSizes;
    }

    public BatchSizes getBatchSizes() {
        return this.batchSizes;
    }

    @PostConstruct
    public void init() throws MailboxException {
        if (this.dispatcher == null) {
            this.dispatcher = new MailboxEventDispatcher(this.getDelegationListener());
        }
        if (this.index == null) {
            this.index = new SimpleMessageSearchIndex(this.mailboxSessionMapperFactory, this.mailboxSessionMapperFactory);
        }
        if (this.index instanceof ListeningMessageSearchIndex) {
            this.addGlobalListener((MailboxListener)this.index, null);
        }
        if (this.idGenerator == null) {
            this.idGenerator = new RandomMailboxSessionIdGenerator();
        }
        if (this.quotaManager == null) {
            this.quotaManager = new NoQuotaManager();
        }
        if (this.quotaRootResolver == null) {
            this.quotaRootResolver = new DefaultQuotaRootResolver(this.mailboxSessionMapperFactory);
        }
        if (this.quotaUpdater != null && this.quotaUpdater instanceof MailboxListener) {
            this.addGlobalListener((MailboxListener)this.quotaUpdater, null);
        }
        if (this.copyBatcher == null) {
            this.copyBatcher = new MessageBatcher(0);
        }
        if (this.moveBatcher == null) {
            this.moveBatcher = new MessageBatcher(0);
        }
        if (this.hasCapability(MailboxManager.MailboxCapabilities.Annotation)) {
            MailboxSession session = null;
            this.addGlobalListener(new MailboxAnnotationListener(this.mailboxSessionMapperFactory), session);
        }
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return EnumSet.noneOf(MailboxManager.MailboxCapabilities.class);
    }

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities() {
        return EnumSet.noneOf(MailboxManager.MessageCapabilities.class);
    }

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedSearchCapabilities() {
        return this.index.getSupportedCapabilities();
    }

    public DelegatingMailboxListener getDelegationListener() {
        if (this.delegatingListener == null) {
            this.delegatingListener = new DefaultDelegatingMailboxListener();
        }
        return this.delegatingListener;
    }

    public MessageSearchIndex getMessageSearchIndex() {
        return this.index;
    }

    public QuotaRootResolver getQuotaRootResolver() {
        return this.quotaRootResolver;
    }

    public QuotaManager getQuotaManager() {
        return this.quotaManager;
    }

    public MailboxEventDispatcher getEventDispatcher() {
        return this.dispatcher;
    }

    public MailboxSessionMapperFactory getMapperFactory() {
        return this.mailboxSessionMapperFactory;
    }

    public MailboxPathLocker getLocker() {
        return this.locker;
    }

    public MailboxACLResolver getAclResolver() {
        return this.aclResolver;
    }

    public GroupMembershipResolver getGroupMembershipResolver() {
        return this.groupMembershipResolver;
    }

    public MessageParser getMessageParser() {
        return this.messageParser;
    }

    public void setDelegatingMailboxListener(DelegatingMailboxListener delegatingListener) {
        this.delegatingListener = delegatingListener;
        this.dispatcher = new MailboxEventDispatcher(this.getDelegationListener());
    }

    public void setMessageSearchIndex(MessageSearchIndex index) {
        this.index = index;
    }

    protected int randomUidValidity() {
        return Math.abs(RANDOM.nextInt());
    }

    public MailboxSession createSystemSession(String userName, Logger log) {
        return this.createSession(userName, null, log, MailboxSession.SessionType.System);
    }

    protected MailboxSession createSession(String userName, String password, Logger log, MailboxSession.SessionType type) {
        return new SimpleMailboxSession(this.randomId(), userName, password, log, new ArrayList<Locale>(), this.getDelimiter(), type);
    }

    protected long randomId() {
        return this.idGenerator.nextId();
    }

    public char getDelimiter() {
        return '.';
    }

    private boolean login(String userid, String passwd) throws MailboxException {
        return this.authenticator.isAuthentic(userid, passwd);
    }

    public MailboxSession login(String userid, String passwd, Logger log) throws BadCredentialsException, MailboxException {
        if (this.login(userid, passwd)) {
            return this.createSession(userid, passwd, log, MailboxSession.SessionType.User);
        }
        throw new BadCredentialsException();
    }

    public MailboxSession loginAsOtherUser(String adminUserid, String passwd, String otherUserId, Logger log) throws MailboxException {
        if (!this.login(adminUserid, passwd)) {
            throw new BadCredentialsException();
        }
        Authorizator.AuthorizationState authorizationState = this.authorizator.canLoginAsOtherUser(adminUserid, otherUserId);
        switch (authorizationState) {
            case ALLOWED: {
                return this.createSystemSession(otherUserId, log);
            }
            case NOT_ADMIN: {
                throw new NotAdminException();
            }
            case UNKNOWN_USER: {
                throw new UserDoesNotExistException(otherUserId);
            }
        }
        throw new RuntimeException("Unknown AuthorizationState " + (Object)((Object)authorizationState));
    }

    public void logout(MailboxSession session, boolean force) throws MailboxException {
        if (session != null) {
            session.close();
        }
    }

    protected StoreMessageManager createMessageManager(Mailbox mailbox, MailboxSession session) throws MailboxException {
        return new StoreMessageManager(this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventDispatcher(), this.getLocker(), mailbox, this.getAclResolver(), this.getGroupMembershipResolver(), this.getQuotaManager(), this.getQuotaRootResolver(), this.getMessageParser(), this.getMessageIdFactory(), this.getBatchSizes());
    }

    protected Mailbox doCreateMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return new SimpleMailbox(mailboxPath, this.randomUidValidity());
    }

    public MessageManager getMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailboxRow = mapper.findMailboxByPath(mailboxPath);
        if (mailboxRow == null) {
            session.getLog().info("Mailbox '" + mailboxPath + "' not found.");
            throw new MailboxNotFoundException(mailboxPath);
        }
        session.getLog().debug("Loaded mailbox " + mailboxPath);
        return this.createMessageManager(mailboxRow, session);
    }

    public MessageManager getMailbox(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailboxRow = mapper.findMailboxById(mailboxId);
        if (mailboxRow == null) {
            session.getLog().info("Mailbox '" + mailboxId.serialize() + "' not found.");
            throw new MailboxNotFoundException(mailboxId.serialize());
        }
        if (!this.belongsToCurrentUser(mailboxRow, session)) {
            session.getLog().info("Mailbox '" + mailboxId.serialize() + "' does not belong to user '" + session.getUser() + "' but to '" + mailboxRow.getUser());
            throw new MailboxNotFoundException(mailboxId.serialize());
        }
        session.getLog().debug("Loaded mailbox " + mailboxId.serialize());
        return this.createMessageManager(mailboxRow, session);
    }

    private boolean belongsToCurrentUser(Mailbox mailbox, MailboxSession session) {
        return session.getUser().isSameUser(mailbox.getUser());
    }

    public Optional<MailboxId> createMailbox(MailboxPath mailboxPath, final MailboxSession mailboxSession) throws MailboxException {
        mailboxSession.getLog().debug("createMailbox " + mailboxPath);
        int length = mailboxPath.getName().length();
        if (length == 0) {
            mailboxSession.getLog().warn("Ignoring mailbox with empty name");
        } else {
            if (mailboxPath.getName().charAt(length - 1) == this.getDelimiter()) {
                mailboxPath.setName(mailboxPath.getName().substring(0, length - 1));
            }
            if (this.mailboxExists(mailboxPath, mailboxSession)) {
                throw new MailboxExistsException(mailboxPath.toString());
            }
            final ArrayList mailboxIds = new ArrayList();
            for (final MailboxPath mailbox : mailboxPath.getHierarchyLevels(this.getDelimiter())) {
                this.locker.executeWithLock(mailboxSession, mailbox, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Void>(){

                    public Void execute() throws MailboxException {
                        if (!StoreMailboxManager.this.mailboxExists(mailbox, mailboxSession)) {
                            final Mailbox m = StoreMailboxManager.this.doCreateMailbox(mailbox, mailboxSession);
                            final MailboxMapper mapper = StoreMailboxManager.this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
                            mapper.execute(new Mapper.VoidTransaction(){

                                @Override
                                public void runVoid() throws MailboxException {
                                    mailboxIds.add(mapper.save(m));
                                }
                            });
                            StoreMailboxManager.this.dispatcher.mailboxAdded(mailboxSession, m);
                        }
                        return null;
                    }
                }, true);
            }
            if (!mailboxIds.isEmpty()) {
                return Optional.fromNullable((Object)Iterables.getLast(mailboxIds));
            }
        }
        return Optional.absent();
    }

    public void deleteMailbox(final MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        session.getLog().info("deleteMailbox " + mailboxPath);
        final MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.execute(new Mapper.Transaction<Mailbox>(){

            @Override
            public Mailbox run() throws MailboxException {
                Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
                if (mailbox == null) {
                    throw new MailboxNotFoundException("Mailbox not found");
                }
                SimpleMailbox m = new SimpleMailbox(mailbox);
                mapper.delete(mailbox);
                return m;
            }
        });
        this.dispatcher.mailboxDeleted(session, mailbox);
    }

    public void renameMailbox(final MailboxPath from, final MailboxPath to, final MailboxSession session) throws MailboxException {
        final Logger log = session.getLog();
        if (log.isDebugEnabled()) {
            log.debug("renameMailbox " + from + " to " + to);
        }
        if (this.mailboxExists(to, session)) {
            throw new MailboxExistsException(to.toString());
        }
        final MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        mapper.execute(new Mapper.VoidTransaction(){

            @Override
            public void runVoid() throws MailboxException {
                Mailbox mailbox = mapper.findMailboxByPath(from);
                if (mailbox == null) {
                    throw new MailboxNotFoundException(from);
                }
                mailbox.setNamespace(to.getNamespace());
                mailbox.setUser(to.getUser());
                mailbox.setName(to.getName());
                mapper.save(mailbox);
                StoreMailboxManager.this.dispatcher.mailboxRenamed(session, from, mailbox);
                final MailboxPath children = new MailboxPath("#private", from.getUser(), from.getName() + StoreMailboxManager.this.getDelimiter() + "%");
                StoreMailboxManager.this.locker.executeWithLock(session, children, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Void>(){

                    public Void execute() throws MailboxException {
                        List<Mailbox> subMailboxes = mapper.findMailboxWithPathLike(children);
                        for (Mailbox sub : subMailboxes) {
                            String subOriginalName = sub.getName();
                            String subNewName = to.getName() + subOriginalName.substring(from.getName().length());
                            MailboxPath fromPath = new MailboxPath(children, subOriginalName);
                            sub.setName(subNewName);
                            mapper.save(sub);
                            StoreMailboxManager.this.dispatcher.mailboxRenamed(session, fromPath, sub);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Rename mailbox sub-mailbox " + subOriginalName + " to " + subNewName);
                        }
                        return null;
                    }
                }, true);
            }
        });
    }

    public List<MessageRange> copyMessages(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.copyMessages(set, session, toMailbox, fromMailbox);
    }

    public List<MessageRange> copyMessages(MessageRange set, MailboxId from, MailboxId to, MailboxSession session) throws MailboxException {
        StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.copyMessages(set, session, toMailbox, fromMailbox);
    }

    private List<MessageRange> copyMessages(MessageRange set, final MailboxSession session, final StoreMessageManager toMailbox, final StoreMessageManager fromMailbox) throws MailboxException {
        return this.copyBatcher.batchMessages(set, new MessageBatcher.BatchedOperation(){

            @Override
            public List<MessageRange> execute(MessageRange messageRange) throws MailboxException {
                return fromMailbox.copyTo(messageRange, toMailbox, session);
            }
        });
    }

    public List<MessageRange> moveMessages(MessageRange set, MailboxPath from, MailboxPath to, final MailboxSession session) throws MailboxException {
        final StoreMessageManager toMailbox = (StoreMessageManager)this.getMailbox(to, session);
        final StoreMessageManager fromMailbox = (StoreMessageManager)this.getMailbox(from, session);
        return this.moveBatcher.batchMessages(set, new MessageBatcher.BatchedOperation(){

            @Override
            public List<MessageRange> execute(MessageRange messageRange) throws MailboxException {
                return fromMailbox.moveTo(messageRange, toMailbox, session);
            }
        });
    }

    public List<MailboxMetaData> search(MailboxQuery mailboxExpression, MailboxSession session) throws MailboxException {
        char localWildcard = mailboxExpression.getLocalWildcard();
        char freeWildcard = mailboxExpression.getFreeWildcard();
        String baseName = mailboxExpression.getBase().getName();
        int baseLength = baseName == null ? 0 : baseName.length();
        String combinedName = mailboxExpression.getCombinedName().replace(freeWildcard, '%').replace(localWildcard, '%') + '%';
        MailboxPath search = new MailboxPath(mailboxExpression.getBase(), combinedName);
        List<Mailbox> mailboxes = this.mailboxSessionMapperFactory.getMailboxMapper(session).findMailboxWithPathLike(search);
        ArrayList<MailboxMetaData> results = new ArrayList<MailboxMetaData>(mailboxes.size());
        for (Mailbox mailbox : mailboxes) {
            String match;
            String name = mailbox.getName();
            if (!this.belongsToNamespaceAndUser(mailboxExpression.getBase(), mailbox) || !name.startsWith(baseName) || !mailboxExpression.isExpressionMatch(match = name.substring(baseLength))) continue;
            List<Mailbox> potentialChildren = mailboxes;
            MailboxMetaData.Children inferiors = this.hasChildIn(mailbox, potentialChildren, session) ? MailboxMetaData.Children.HAS_CHILDREN : MailboxMetaData.Children.HAS_NO_CHILDREN;
            MailboxPath mailboxPath = new MailboxPath(mailbox.getNamespace(), mailbox.getUser(), name);
            results.add(new SimpleMailboxMetaData(mailboxPath, mailbox.getMailboxId(), this.getDelimiter(), inferiors, MailboxMetaData.Selectability.NONE));
        }
        Collections.sort(results, new StandardMailboxMetaDataComparator());
        return results;
    }

    private boolean hasChildIn(Mailbox parentMailbox, List<Mailbox> mailboxesWithPathLike, MailboxSession mailboxSession) {
        return FluentIterable.from(mailboxesWithPathLike).anyMatch(this.isChildren(parentMailbox, mailboxSession));
    }

    private Predicate<Mailbox> isChildren(final Mailbox parentMailbox, final MailboxSession mailboxSession) {
        return new Predicate<Mailbox>(){

            public boolean apply(Mailbox mailbox) {
                return mailbox.isChildOf(parentMailbox, mailboxSession);
            }
        };
    }

    public List<MessageId> search(MultimailboxesSearchQuery expression, MailboxSession session, long limit) throws MailboxException {
        return this.index.search(session, expression, limit);
    }

    public boolean belongsToNamespaceAndUser(MailboxPath base, Mailbox mailbox) {
        if (mailbox.getUser() == null) {
            return base.getUser() == null && mailbox.getNamespace().equals(base.getNamespace());
        }
        return mailbox.getNamespace().equals(base.getNamespace()) && mailbox.getUser().equals(base.getUser());
    }

    public boolean mailboxExists(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        try {
            MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
            mapper.findMailboxByPath(mailboxPath);
            return true;
        }
        catch (MailboxNotFoundException e) {
            return false;
        }
    }

    public void addListener(MailboxPath path, MailboxListener listener, MailboxSession session) throws MailboxException {
        this.delegatingListener.addListener(path, listener, session);
    }

    public void endProcessingRequest(MailboxSession session) {
        if (this.mailboxSessionMapperFactory instanceof RequestAware) {
            this.mailboxSessionMapperFactory.endProcessingRequest(session);
        }
    }

    public void startProcessingRequest(MailboxSession session) {
    }

    public List<MailboxPath> list(MailboxSession session) throws MailboxException {
        ArrayList<MailboxPath> mList = new ArrayList<MailboxPath>();
        List<Mailbox> mailboxes = this.mailboxSessionMapperFactory.getMailboxMapper(session).list();
        for (Mailbox m : mailboxes) {
            mList.add(m.generateAssociatedPath());
        }
        return Collections.unmodifiableList(mList);
    }

    public void addGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        this.delegatingListener.addGlobalListener(listener, session);
    }

    public void removeListener(MailboxPath mailboxPath, MailboxListener listener, MailboxSession session) throws MailboxException {
        this.delegatingListener.removeListener(mailboxPath, listener, session);
    }

    public void removeGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        this.delegatingListener.removeGlobalListener(listener, session);
    }

    public boolean hasRight(MailboxPath mailboxPath, MailboxACL.MailboxACLRight right, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
        MailboxSession.User user = session.getUser();
        String userName = user != null ? user.getUserName() : null;
        return this.aclResolver.hasRight(userName, this.groupMembershipResolver, right, mailbox.getACL(), mailbox.getUser(), new GroupFolderResolver(session).isGroupFolder(mailbox));
    }

    public MailboxACL.MailboxACLRights myRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
        MailboxSession.User user = session.getUser();
        if (user != null) {
            return this.aclResolver.resolveRights(user.getUserName(), this.groupMembershipResolver, mailbox.getACL(), mailbox.getUser(), new GroupFolderResolver(session).isGroupFolder(mailbox));
        }
        return SimpleMailboxACL.NO_RIGHTS;
    }

    public MailboxACL.MailboxACLRights[] listRigths(MailboxPath mailboxPath, MailboxACL.MailboxACLEntryKey key, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
        return this.aclResolver.listRights(key, this.groupMembershipResolver, mailbox.getUser(), new GroupFolderResolver(session).isGroupFolder(mailbox));
    }

    public void setRights(MailboxPath mailboxPath, final MailboxACL.MailboxACLCommand mailboxACLCommand, MailboxSession session) throws MailboxException {
        final MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        final Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
        mapper.execute(new Mapper.VoidTransaction(){

            @Override
            public void runVoid() throws MailboxException {
                mapper.updateACL(mailbox, mailboxACLCommand);
            }
        });
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        final AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        final MailboxId mailboxId = this.getMailbox(mailboxPath, session).getId();
        return annotationMapper.execute(new Mapper.Transaction<List<MailboxAnnotation>>(){

            @Override
            public List<MailboxAnnotation> run() throws MailboxException {
                return annotationMapper.getAllAnnotations(mailboxId);
            }
        });
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxPath mailboxPath, MailboxSession session, final Set<MailboxAnnotationKey> keys) throws MailboxException {
        final AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        final MailboxId mailboxId = this.getMailbox(mailboxPath, session).getId();
        return annotationMapper.execute(new Mapper.Transaction<List<MailboxAnnotation>>(){

            @Override
            public List<MailboxAnnotation> run() throws MailboxException {
                return annotationMapper.getAnnotationsByKeys(mailboxId, keys);
            }
        });
    }

    public void updateAnnotations(MailboxPath mailboxPath, MailboxSession session, final List<MailboxAnnotation> mailboxAnnotations) throws MailboxException {
        final AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        final MailboxId mailboxId = this.getMailbox(mailboxPath, session).getId();
        annotationMapper.execute(new Mapper.VoidTransaction(){

            @Override
            public void runVoid() throws MailboxException {
                for (MailboxAnnotation annotation : mailboxAnnotations) {
                    if (annotation.isNil()) {
                        annotationMapper.deleteAnnotation(mailboxId, annotation.getKey());
                        continue;
                    }
                    if (!StoreMailboxManager.this.canInsertOrUpdate(mailboxId, annotation, annotationMapper)) continue;
                    annotationMapper.insertAnnotation(mailboxId, annotation);
                }
            }
        });
    }

    private boolean canInsertOrUpdate(MailboxId mailboxId, MailboxAnnotation annotation, AnnotationMapper annotationMapper) throws AnnotationException {
        if (annotation.size() > this.limitAnnotationSize) {
            throw new AnnotationException("annotation too big.");
        }
        if (!annotationMapper.exist(mailboxId, annotation) && annotationMapper.countAnnotations(mailboxId) >= this.limitOfAnnotations) {
            throw new AnnotationException("too many annotations.");
        }
        return true;
    }

    public boolean hasCapability(MailboxManager.MailboxCapabilities capability) {
        return this.getSupportedMailboxCapabilities().contains(capability);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxPath mailboxPath, MailboxSession session, final Set<MailboxAnnotationKey> keys) throws MailboxException {
        final AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        final MailboxId mailboxId = this.getMailbox(mailboxPath, session).getId();
        return annotationMapper.execute(new Mapper.Transaction<List<MailboxAnnotation>>(){

            @Override
            public List<MailboxAnnotation> run() throws MailboxException {
                return annotationMapper.getAnnotationsByKeysWithOneDepth(mailboxId, keys);
            }
        });
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxPath mailboxPath, MailboxSession session, final Set<MailboxAnnotationKey> keys) throws MailboxException {
        final AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        final MailboxId mailboxId = this.getMailbox(mailboxPath, session).getId();
        return annotationMapper.execute(new Mapper.Transaction<List<MailboxAnnotation>>(){

            @Override
            public List<MailboxAnnotation> run() throws MailboxException {
                return annotationMapper.getAnnotationsByKeysWithAllDepth(mailboxId, keys);
            }
        });
    }

    public boolean hasChildren(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
        return mapper.hasChildren(mailbox, session.getPathDelimiter());
    }
}

