/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Attachment;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;

public class StoreAttachmentManager
implements AttachmentManager {
    private final AttachmentMapperFactory attachmentMapperFactory;

    @Inject
    public StoreAttachmentManager(AttachmentMapperFactory attachmentMapperFactory) {
        this.attachmentMapperFactory = attachmentMapperFactory;
    }

    protected AttachmentMapperFactory getAttachmentMapperFactory() {
        return this.attachmentMapperFactory;
    }

    protected AttachmentMapper getAttachmentMapper(MailboxSession mailboxSession) throws MailboxException {
        return this.attachmentMapperFactory.getAttachmentMapper(mailboxSession);
    }

    public Attachment getAttachment(AttachmentId attachmentId, MailboxSession mailboxSession) throws MailboxException, AttachmentNotFoundException {
        return this.getAttachmentMapper(mailboxSession).getAttachment(attachmentId);
    }

    public List<Attachment> getAttachments(List<AttachmentId> attachmentIds, MailboxSession mailboxSession) throws MailboxException {
        return this.getAttachmentMapper(mailboxSession).getAttachments(attachmentIds);
    }

    public void storeAttachment(Attachment attachment, MailboxSession mailboxSession) throws MailboxException {
        this.getAttachmentMapper(mailboxSession).storeAttachment(attachment);
    }

    public void storeAttachments(Collection<Attachment> attachments, MailboxSession mailboxSession) throws MailboxException {
        this.getAttachmentMapper(mailboxSession).storeAttachments(attachments);
    }
}

