/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.base.Objects;
import java.util.Date;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;

public class SimpleMessageMetaData
implements MessageMetaData {
    private final MessageUid uid;
    private final Flags flags;
    private final long size;
    private final Date internalDate;
    private final long modSeq;
    private final MessageId messageId;

    public SimpleMessageMetaData(MessageUid uid, long modSeq, Flags flags, long size, Date internalDate, MessageId messageId) {
        this.uid = uid;
        this.flags = flags;
        this.size = size;
        this.modSeq = modSeq;
        this.internalDate = internalDate;
        this.messageId = messageId;
    }

    public SimpleMessageMetaData(MailboxMessage message) {
        this(message.getUid(), message.getModSeq(), message.createFlags(), message.getFullContentOctets(), message.getInternalDate(), message.getMessageId());
    }

    public Flags getFlags() {
        return this.flags;
    }

    public long getSize() {
        return this.size;
    }

    public Date getInternalDate() {
        return this.internalDate;
    }

    public MessageUid getUid() {
        return this.uid;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleMessageMetaData) {
            return this.uid.equals((Object)((SimpleMessageMetaData)obj).getUid());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uid});
    }

    public long getModSeq() {
        return this.modSeq;
    }
}

