/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MessageResult;

public final class ResultHeader
implements MessageResult.Header {
    private final String name;
    private final String value;
    private final long size;
    private static final Charset US_ASCII = Charset.forName("US-ASCII");

    public ResultHeader(String name, String value) {
        this.name = name;
        this.value = value;
        this.size = name.length() + value.length() + 2;
    }

    public String getName() throws MailboxException {
        return this.name;
    }

    public String getValue() throws MailboxException {
        return this.value;
    }

    public long size() {
        return this.size;
    }

    public String toString() {
        return "[HEADER " + this.name + ": " + this.value + "]";
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream((this.name + ": " + this.value).getBytes(US_ASCII));
    }
}

