/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.RequestAware;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MailboxMapperFactory;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;

public abstract class MailboxSessionMapperFactory
implements RequestAware,
MailboxMapperFactory,
MessageMapperFactory,
AttachmentMapperFactory,
SubscriptionMapperFactory {
    protected static final String ATTACHMENTMAPPER = "ATTACHMENTMAPPER";
    protected static final String MESSAGEMAPPER = "MESSAGEMAPPER";
    protected static final String MESSAGEIDMAPPER = "MESSAGEIDMAPPER";
    protected static final String MAILBOXMAPPER = "MAILBOXMAPPER";
    protected static final String SUBSCRIPTIONMAPPER = "SUBSCRIPTIONMAPPER";
    protected static final String ANNOTATIONMAPPER = "ANNOTATIONMAPPER";

    @Override
    public MessageMapper getMessageMapper(MailboxSession session) throws MailboxException {
        MessageMapper mapper = (MessageMapper)session.getAttributes().get(MESSAGEMAPPER);
        if (mapper == null) {
            mapper = this.createMessageMapper(session);
            session.getAttributes().put(MESSAGEMAPPER, mapper);
        }
        return mapper;
    }

    public MessageIdMapper getMessageIdMapper(MailboxSession session) throws MailboxException {
        MessageIdMapper mapper = (MessageIdMapper)session.getAttributes().get(MESSAGEIDMAPPER);
        if (mapper == null) {
            mapper = this.createMessageIdMapper(session);
            session.getAttributes().put(MESSAGEIDMAPPER, mapper);
        }
        return mapper;
    }

    @Override
    public AttachmentMapper getAttachmentMapper(MailboxSession session) throws MailboxException {
        AttachmentMapper mapper = (AttachmentMapper)session.getAttributes().get(ATTACHMENTMAPPER);
        if (mapper == null) {
            mapper = this.createAttachmentMapper(session);
            session.getAttributes().put(ATTACHMENTMAPPER, mapper);
        }
        return mapper;
    }

    public AnnotationMapper getAnnotationMapper(MailboxSession session) throws MailboxException {
        AnnotationMapper mapper = (AnnotationMapper)session.getAttributes().get(ANNOTATIONMAPPER);
        if (mapper == null) {
            mapper = this.createAnnotationMapper(session);
            session.getAttributes().put(ANNOTATIONMAPPER, mapper);
        }
        return mapper;
    }

    public abstract AnnotationMapper createAnnotationMapper(MailboxSession var1) throws MailboxException;

    public abstract MessageMapper createMessageMapper(MailboxSession var1) throws MailboxException;

    public abstract MessageIdMapper createMessageIdMapper(MailboxSession var1) throws MailboxException;

    public abstract AttachmentMapper createAttachmentMapper(MailboxSession var1) throws MailboxException;

    @Override
    public MailboxMapper getMailboxMapper(MailboxSession session) throws MailboxException {
        MailboxMapper mapper = (MailboxMapper)session.getAttributes().get(MAILBOXMAPPER);
        if (mapper == null) {
            mapper = this.createMailboxMapper(session);
            session.getAttributes().put(MAILBOXMAPPER, mapper);
        }
        return mapper;
    }

    public abstract MailboxMapper createMailboxMapper(MailboxSession var1) throws MailboxException;

    @Override
    public SubscriptionMapper getSubscriptionMapper(MailboxSession session) throws SubscriptionException {
        SubscriptionMapper mapper = (SubscriptionMapper)session.getAttributes().get(SUBSCRIPTIONMAPPER);
        if (mapper == null) {
            mapper = this.createSubscriptionMapper(session);
            session.getAttributes().put(SUBSCRIPTIONMAPPER, mapper);
        }
        return mapper;
    }

    public abstract SubscriptionMapper createSubscriptionMapper(MailboxSession var1) throws SubscriptionException;

    public abstract UidProvider getUidProvider();

    public abstract ModSeqProvider getModSeqProvider();

    public void endProcessingRequest(MailboxSession session) {
        if (session == null) {
            return;
        }
        MessageMapper messageMapper = (MessageMapper)session.getAttributes().get(MESSAGEMAPPER);
        MailboxMapper mailboxMapper = (MailboxMapper)session.getAttributes().get(MAILBOXMAPPER);
        SubscriptionMapper subscriptionMapper = (SubscriptionMapper)session.getAttributes().get(SUBSCRIPTIONMAPPER);
        if (messageMapper != null) {
            messageMapper.endRequest();
        }
        if (mailboxMapper != null) {
            mailboxMapper.endRequest();
        }
        if (subscriptionMapper != null) {
            subscriptionMapper.endRequest();
        }
    }

    public void startProcessingRequest(MailboxSession session) {
    }
}

