/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.ArrayList;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MailboxACL;

public class MailboxMetaData
implements MessageManager.MetaData {
    private final long recentCount;
    private final List<MessageUid> recent;
    private final Flags premanentFlags;
    private final long uidValidity;
    private final MessageUid nextUid;
    private final long messageCount;
    private final long unseenCount;
    private final MessageUid firstUnseen;
    private final boolean writeable;
    private final long highestModSeq;
    private final boolean modSeqPermanent;
    private final MailboxACL acl;

    public MailboxMetaData(List<MessageUid> recent, Flags premanentFlags, long uidValidity, MessageUid uidNext, long highestModSeq, long messageCount, long unseenCount, MessageUid firstUnseen, boolean writeable, boolean modSeqPermanent, MailboxACL acl) {
        this.recent = recent == null ? new ArrayList<MessageUid>() : recent;
        this.highestModSeq = highestModSeq;
        this.recentCount = this.recent.size();
        this.premanentFlags = premanentFlags;
        this.uidValidity = uidValidity;
        this.nextUid = uidNext;
        this.messageCount = messageCount;
        this.unseenCount = unseenCount;
        this.firstUnseen = firstUnseen;
        this.writeable = writeable;
        this.modSeqPermanent = modSeqPermanent;
        this.acl = acl;
    }

    public long countRecent() {
        return this.recentCount;
    }

    public Flags getPermanentFlags() {
        return this.premanentFlags;
    }

    public List<MessageUid> getRecent() {
        return this.recent;
    }

    public long getUidValidity() {
        return this.uidValidity;
    }

    public MessageUid getUidNext() {
        return this.nextUid;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public long getUnseenCount() {
        return this.unseenCount;
    }

    public MessageUid getFirstUnseen() {
        return this.firstUnseen;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public long getHighestModSeq() {
        return this.highestModSeq;
    }

    public boolean isModSeqPermanent() {
        return this.modSeqPermanent;
    }

    public MailboxACL getACL() {
        return this.acl;
    }
}

