/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.base.Optional;
import org.apache.james.mailbox.store.Authorizator;

public class FakeAuthorizator
implements Authorizator {
    private final Optional<String> adminId;
    private final Optional<String> delegatedUserId;

    public static FakeAuthorizator defaultReject() {
        return new FakeAuthorizator((Optional<String>)Optional.absent(), (Optional<String>)Optional.absent());
    }

    public static FakeAuthorizator forUserAndAdmin(String admin, String user) {
        return new FakeAuthorizator((Optional<String>)Optional.of((Object)admin), (Optional<String>)Optional.of((Object)user));
    }

    private FakeAuthorizator(Optional<String> adminId, Optional<String> userId) {
        this.adminId = adminId;
        this.delegatedUserId = userId;
    }

    @Override
    public Authorizator.AuthorizationState canLoginAsOtherUser(String userId, String otherUserId) {
        if (!this.adminId.isPresent() || !this.delegatedUserId.isPresent()) {
            return Authorizator.AuthorizationState.NOT_ADMIN;
        }
        if (!((String)this.adminId.get()).equals(userId)) {
            return Authorizator.AuthorizationState.NOT_ADMIN;
        }
        if (!otherUserId.equals(this.delegatedUserId.get())) {
            return Authorizator.AuthorizationState.UNKNOWN_USER;
        }
        return Authorizator.AuthorizationState.ALLOWED;
    }
}

