/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class BatchSizes {
    public static final int DEFAULT_BATCH_SIZE = 200;
    private final int fetchMetadata;
    private final int fetchHeaders;
    private final int fetchBody;
    private final int fetchFull;
    private final int copyBatchSize;
    private final int moveBatchSize;

    public static BatchSizes defaultValues() {
        return new Builder().build();
    }

    public static BatchSizes uniqueBatchSize(int batchSize) {
        return new Builder().fetchMetadata(batchSize).fetchHeaders(batchSize).fetchBody(batchSize).fetchFull(batchSize).copyBatchSize(batchSize).moveBatchSize(batchSize).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private BatchSizes(int fetchMetadata, int fetchHeaders, int fetchBody, int fetchFull, int copyBatchSize, int moveBatchSize) {
        this.fetchMetadata = fetchMetadata;
        this.fetchHeaders = fetchHeaders;
        this.fetchBody = fetchBody;
        this.fetchFull = fetchFull;
        this.copyBatchSize = copyBatchSize;
        this.moveBatchSize = moveBatchSize;
    }

    public int getFetchMetadata() {
        return this.fetchMetadata;
    }

    public int getFetchHeaders() {
        return this.fetchHeaders;
    }

    public int getFetchBody() {
        return this.fetchBody;
    }

    public int getFetchFull() {
        return this.fetchFull;
    }

    public int getCopyBatchSize() {
        return this.copyBatchSize;
    }

    public int getMoveBatchSize() {
        return this.moveBatchSize;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BatchSizes) {
            BatchSizes other = (BatchSizes)obj;
            return Objects.equal((Object)this.fetchMetadata, (Object)other.fetchMetadata) && Objects.equal((Object)this.fetchHeaders, (Object)other.fetchHeaders) && Objects.equal((Object)this.fetchBody, (Object)other.fetchBody) && Objects.equal((Object)this.fetchFull, (Object)other.fetchFull) && Objects.equal((Object)this.copyBatchSize, (Object)other.copyBatchSize) && Objects.equal((Object)this.moveBatchSize, (Object)other.moveBatchSize);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fetchMetadata, this.fetchHeaders, this.fetchBody, this.fetchFull, this.copyBatchSize, this.moveBatchSize});
    }

    public String toString() {
        return MoreObjects.toStringHelper(BatchSizes.class).add("fetchMetadata", this.fetchMetadata).add("fetchHeaders", this.fetchHeaders).add("fetchBody", this.fetchBody).add("fetchFull", this.fetchFull).add("copyBatchSize", this.copyBatchSize).add("moveBatchSize", this.moveBatchSize).toString();
    }

    public static class Builder {
        private Optional<Integer> fetchMetadata = Optional.absent();
        private Optional<Integer> fetchHeaders = Optional.absent();
        private Optional<Integer> fetchBody = Optional.absent();
        private Optional<Integer> fetchFull = Optional.absent();
        private Optional<Integer> copyBatchSize = Optional.absent();
        private Optional<Integer> moveBatchSize = Optional.absent();

        private Builder() {
        }

        public Builder fetchMetadata(int batchSize) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"'fetchMetadata' must be greater than zero");
            this.fetchMetadata = Optional.of((Object)batchSize);
            return this;
        }

        public Builder fetchHeaders(int batchSize) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"'fetchHeaders' must be greater than zero");
            this.fetchHeaders = Optional.of((Object)batchSize);
            return this;
        }

        public Builder fetchBody(int batchSize) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"'fetchBody' must be greater than zero");
            this.fetchBody = Optional.of((Object)batchSize);
            return this;
        }

        public Builder fetchFull(int batchSize) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"'fetchFull' must be greater than zero");
            this.fetchFull = Optional.of((Object)batchSize);
            return this;
        }

        public Builder copyBatchSize(int batchSize) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"'copyBatchSize' must be greater than zero");
            this.copyBatchSize = Optional.of((Object)batchSize);
            return this;
        }

        public Builder moveBatchSize(int batchSize) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"'moveBatchSize' must be greater than zero");
            this.moveBatchSize = Optional.of((Object)batchSize);
            return this;
        }

        public BatchSizes build() {
            return new BatchSizes((Integer)this.fetchMetadata.or((Object)200), (Integer)this.fetchHeaders.or((Object)200), (Integer)this.fetchBody.or((Object)200), (Integer)this.fetchFull.or((Object)200), (Integer)this.copyBatchSize.or((Object)200), (Integer)this.moveBatchSize.or((Object)200));
        }
    }
}

