/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MessageResult;

public class MimeBodyElement
implements FetchResponse.BodyElement {
    private final String name;
    protected final List<MessageResult.Header> headers;
    protected long size;
    private static final Charset US_ASCII = Charset.forName("US-ASCII");

    public MimeBodyElement(String name, List<MessageResult.Header> headers) throws MailboxException {
        this.name = name;
        this.headers = headers;
        this.size = this.calculateSize(headers);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected long calculateSize(List<MessageResult.Header> headers) throws MailboxException {
        int result;
        if (headers.isEmpty()) {
            result = 0;
        } else {
            int count = 0;
            for (MessageResult.Header header : headers) {
                count = (int)((long)count + (header.size() + (long)"\r\n".length()));
            }
            result = count + "\r\n".length();
        }
        return result;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (MessageResult.Header header : this.headers) {
            try {
                out.write((header.getName() + ": " + header.getValue() + "\r\n").getBytes(US_ASCII));
            }
            catch (MailboxException e) {
                throw new IOException("Unable to read header", e);
            }
        }
        if (this.size > 0L) {
            out.write("\r\n".getBytes());
        }
        return new ByteArrayInputStream(out.toByteArray());
    }
}

