/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.SystemMessage;
import org.apache.james.imap.processor.base.AbstractChainedProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.slf4j.Logger;

public class SystemMessageProcessor
extends AbstractChainedProcessor<SystemMessage> {
    private final MailboxManager mailboxManager;

    public SystemMessageProcessor(ImapProcessor next, MailboxManager mailboxManager) {
        super(SystemMessage.class, next);
        this.mailboxManager = mailboxManager;
    }

    @Override
    protected void doProcess(SystemMessage message, ImapProcessor.Responder responder, ImapSession session) {
        block5: {
            try {
                switch (message) {
                    case FORCE_LOGOUT: {
                        this.forceLogout(session);
                        break;
                    }
                }
            }
            catch (MailboxException e) {
                Logger log = session.getLog();
                if (!log.isDebugEnabled()) break block5;
                log.debug("Cannot force logout", (Throwable)e);
            }
        }
    }

    private void forceLogout(ImapSession imapSession) throws MailboxException {
        MailboxSession session = ImapSessionUtils.getMailboxSession(imapSession);
        if (session == null) {
            if (imapSession.getLog().isTraceEnabled()) {
                imapSession.getLog().trace("No mailbox session so no force logout needed");
            }
        } else {
            session.close();
            this.mailboxManager.logout(session, true);
        }
    }
}

