/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.SubscribeRequest;
import org.apache.james.imap.processor.AbstractSubscriptionProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.metrics.api.MetricFactory;

public class SubscribeProcessor
extends AbstractSubscriptionProcessor<SubscribeRequest> {
    public SubscribeProcessor(ImapProcessor next, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(SubscribeRequest.class, next, mailboxManager, subscriptionManager, factory, metricFactory);
    }

    @Override
    protected void doProcessRequest(SubscribeRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        String mailboxName = request.getMailboxName();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        try {
            this.getSubscriptionManager().subscribe(mailboxSession, mailboxName);
            this.unsolicitedResponses(session, responder, false);
            this.okComplete(command, tag, responder);
        }
        catch (SubscriptionException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("Subscribe failed for mailbox " + mailboxName, (Throwable)e);
            }
            this.unsolicitedResponses(session, responder, false);
            this.no(command, tag, responder, HumanReadableText.GENERIC_SUBSCRIPTION_FAILURE);
        }
    }
}

