/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.SetQuotaRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;

public class SetQuotaProcessor
extends AbstractMailboxProcessor<SetQuotaRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> CAPABILITIES = Collections.singletonList("QUOTA");

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    public SetQuotaProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(SetQuotaRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(SetQuotaRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        Object[] params = new Object[]{"Full admin rights", command.getName(), "Can not perform SETQUOTA commands"};
        HumanReadableText humanReadableText = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
        this.no(command, tag, responder, humanReadableText);
    }
}

