/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.SetAnnotationRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.AnnotationException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;

public class SetAnnotationProcessor
extends AbstractMailboxProcessor<SetAnnotationRequest>
implements CapabilityImplementingProcessor {
    public SetAnnotationProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(SetAnnotationRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return ImmutableList.of((Object)"ANNOTATION");
    }

    @Override
    protected void doProcess(SetAnnotationRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        String mailboxName = message.getMailboxName();
        try {
            MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
            mailboxManager.updateAnnotations(mailboxPath, mailboxSession, message.getMailboxAnnotations());
            this.okComplete(command, tag, responder);
        }
        catch (MailboxNotFoundException e) {
            session.getLog().info(command.getName() + " failed for mailbox " + mailboxName, (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate());
        }
        catch (AnnotationException e) {
            session.getLog().info(command.getName() + " failed for mailbox " + mailboxName, (Throwable)e);
            this.no(command, tag, responder, new HumanReadableText("org.apache.james.imap.ANNOTATION_ERROR_KEY", e.getMessage()));
        }
        catch (MailboxException e) {
            session.getLog().info(command.getName() + " failed for mailbox " + mailboxName, (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }
}

