/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.RenameRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.TooLongMailboxNameException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;

public class RenameProcessor
extends AbstractMailboxProcessor<RenameRequest> {
    public RenameProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(RenameRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(RenameRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        PathConverter pathConverter = PathConverter.forSession(session);
        MailboxPath existingPath = pathConverter.buildFullPath(request.getExistingName());
        MailboxPath newPath = pathConverter.buildFullPath(request.getNewName());
        try {
            MailboxManager mailboxManager = this.getMailboxManager();
            MailboxSession mailboxsession = ImapSessionUtils.getMailboxSession(session);
            mailboxManager.renameMailbox(existingPath, newPath, mailboxsession);
            if (existingPath.getName().equalsIgnoreCase("INBOX") && !mailboxManager.mailboxExists(existingPath, mailboxsession)) {
                mailboxManager.createMailbox(existingPath, mailboxsession);
            }
            this.okComplete(command, tag, responder);
            this.unsolicitedResponses(session, responder, false);
        }
        catch (MailboxExistsException e) {
            if (session.getLog().isDebugEnabled()) {
                session.getLog().debug("Rename from " + existingPath + " to " + newPath + " failed because the target mailbox exists", (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.FAILURE_MAILBOX_EXISTS);
        }
        catch (MailboxNotFoundException e) {
            if (session.getLog().isDebugEnabled()) {
                session.getLog().debug("Rename from " + existingPath + " to " + newPath + " failed because the source mailbox not exists", (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
        }
        catch (TooLongMailboxNameException e) {
            if (session.getLog().isDebugEnabled()) {
                session.getLog().debug("The mailbox name length is over limit: " + newPath.getName(), (Throwable)e);
            }
            this.taggedBad(command, tag, responder, HumanReadableText.FAILURE_MAILBOX_NAME);
        }
        catch (MailboxException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("Rename from " + existingPath + " to " + newPath + " failed", (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }
}

