/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.NamespaceRequest;
import org.apache.james.imap.message.response.NamespaceResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;

public class NamespaceProcessor
extends AbstractMailboxProcessor<NamespaceRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> CAPS = Collections.unmodifiableList(Arrays.asList("NAMESPACE"));

    public NamespaceProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(NamespaceRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(NamespaceRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        List<NamespaceResponse.Namespace> personalNamespaces = this.buildPersonalNamespaces(mailboxSession, session);
        List<NamespaceResponse.Namespace> otherUsersNamespaces = this.buildOtherUsersSpaces(mailboxSession, session);
        List<NamespaceResponse.Namespace> sharedNamespaces = this.buildSharedNamespaces(mailboxSession, session);
        NamespaceResponse response = new NamespaceResponse(personalNamespaces, otherUsersNamespaces, sharedNamespaces);
        responder.respond(response);
        this.unsolicitedResponses(session, responder, false);
        this.okComplete(command, tag, responder);
    }

    private List<NamespaceResponse.Namespace> buildPersonalNamespaces(MailboxSession mailboxSession, ImapSession session) {
        ArrayList<NamespaceResponse.Namespace> personalSpaces = new ArrayList<NamespaceResponse.Namespace>();
        String personal = "";
        if (session.supportMultipleNamespaces()) {
            personal = mailboxSession.getPersonalSpace();
        }
        personalSpaces.add(new NamespaceResponse.Namespace(personal, mailboxSession.getPathDelimiter()));
        return personalSpaces;
    }

    private List<NamespaceResponse.Namespace> buildOtherUsersSpaces(MailboxSession mailboxSession, ImapSession session) {
        ArrayList<NamespaceResponse.Namespace> otherUsersSpaces;
        String otherUsersSpace = mailboxSession.getOtherUsersSpace();
        if (!session.supportMultipleNamespaces() || otherUsersSpace == null) {
            otherUsersSpaces = null;
        } else {
            otherUsersSpaces = new ArrayList<NamespaceResponse.Namespace>(1);
            otherUsersSpaces.add(new NamespaceResponse.Namespace(otherUsersSpace, mailboxSession.getPathDelimiter()));
        }
        return otherUsersSpaces;
    }

    private List<NamespaceResponse.Namespace> buildSharedNamespaces(MailboxSession mailboxSession, ImapSession session) {
        ArrayList<NamespaceResponse.Namespace> sharedNamespaces = null;
        Collection sharedSpaces = mailboxSession.getSharedSpaces();
        if (session.supportMultipleNamespaces() && !sharedSpaces.isEmpty()) {
            sharedNamespaces = new ArrayList<NamespaceResponse.Namespace>(sharedSpaces.size());
            for (String space : sharedSpaces) {
                sharedNamespaces.add(new NamespaceResponse.Namespace(space, mailboxSession.getPathDelimiter()));
            }
        }
        return sharedNamespaces;
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }
}

