/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.MyRightsRequest;
import org.apache.james.imap.message.response.MyRightsResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.SimpleMailboxACL;
import org.apache.james.metrics.api.MetricFactory;
import org.slf4j.Logger;

public class MyRightsProcessor
extends AbstractMailboxProcessor<MyRightsRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> CAPABILITIES = Collections.singletonList("ACL");

    public MyRightsProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(MyRightsRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(MyRightsRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        String mailboxName = message.getMailboxName();
        try {
            MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
            mailboxManager.getMailbox(mailboxPath, mailboxSession);
            MailboxACL.MailboxACLRights myRights = mailboxManager.myRights(mailboxPath, mailboxSession);
            if (!(myRights.contains(SimpleMailboxACL.Rfc4314Rights.l_Lookup_RIGHT) || myRights.contains(SimpleMailboxACL.Rfc4314Rights.r_Read_RIGHT) || myRights.contains(SimpleMailboxACL.Rfc4314Rights.i_Insert_RIGHT) || myRights.contains(SimpleMailboxACL.Rfc4314Rights.k_CreateMailbox_RIGHT) || myRights.contains(SimpleMailboxACL.Rfc4314Rights.x_DeleteMailbox_RIGHT) || myRights.contains(SimpleMailboxACL.Rfc4314Rights.a_Administer_RIGHT))) {
                this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
            } else {
                MyRightsResponse myRightsResponse = new MyRightsResponse(mailboxName, myRights);
                responder.respond(myRightsResponse);
                this.okComplete(command, tag, responder);
            }
        }
        catch (MailboxNotFoundException e) {
            this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
        }
        catch (MailboxException e) {
            Logger log = session.getLog();
            if (log.isInfoEnabled()) {
                log.info(command.getName() + " failed for mailbox " + mailboxName, (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }
}

