/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.MoveRequest;
import org.apache.james.imap.processor.AbstractMessageRangeProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.metrics.api.MetricFactory;

public class MoveProcessor
extends AbstractMessageRangeProcessor<MoveRequest>
implements CapabilityImplementingProcessor {
    private final boolean moveCapabilitySupported;

    public MoveProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(MoveRequest.class, next, mailboxManager, factory, metricFactory);
        this.moveCapabilitySupported = mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Move);
    }

    @Override
    protected List<MessageRange> process(MailboxPath targetMailbox, SelectedMailbox currentMailbox, MailboxSession mailboxSession, MailboxManager mailboxManager, MessageRange messageSet) throws MailboxException {
        return mailboxManager.moveMessages(messageSet, currentMailbox.getPath(), targetMailbox, mailboxSession);
    }

    @Override
    protected String getOperationName() {
        return "Move";
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        if (this.moveCapabilitySupported) {
            return ImmutableList.of((Object)"MOVE");
        }
        return ImmutableList.of();
    }
}

