/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.CharsetUtil;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.MailboxType;
import org.apache.james.imap.api.process.MailboxTyper;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.ListRequest;
import org.apache.james.imap.message.response.ListResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MailboxQuery;
import org.apache.james.metrics.api.MetricFactory;

public class ListProcessor
extends AbstractMailboxProcessor<ListRequest> {
    public ListProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(ListRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(ListRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        String baseReferenceName = request.getBaseReferenceName();
        String mailboxPatternString = request.getMailboxPattern();
        this.doProcess(baseReferenceName, mailboxPatternString, session, tag, command, responder, null);
    }

    protected ImapResponseMessage createResponse(boolean noInferior, boolean noSelect, boolean marked, boolean unmarked, boolean hasChildren, boolean hasNoChildren, String mailboxName, char delimiter, MailboxType type) {
        return new ListResponse(noInferior, noSelect, marked, unmarked, hasChildren, hasNoChildren, mailboxName, delimiter);
    }

    /*
     * WARNING - void declaration
     */
    protected final void doProcess(String referenceName, String mailboxName, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder, MailboxTyper mailboxTyper) {
        try {
            List<1> results;
            boolean isRelative;
            String user = ImapSessionUtils.getUserName(session);
            final MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
            if (mailboxName.length() == 0) {
                String referenceRoot;
                if (referenceName.length() > 0 && referenceName.charAt(0) == '#') {
                    isRelative = false;
                    int n = referenceName.indexOf(mailboxSession.getPathDelimiter());
                    referenceRoot = n == -1 ? referenceName : referenceName.substring(0, n);
                    referenceRoot = CharsetUtil.decodeModifiedUTF7(referenceRoot);
                } else {
                    referenceRoot = "";
                    isRelative = true;
                }
                final MailboxPath mailboxPath = new MailboxPath(referenceRoot, "", "");
                results = new ArrayList<1>(1);
                results.add(new MailboxMetaData(){

                    public MailboxMetaData.Children inferiors() {
                        return MailboxMetaData.Children.CHILDREN_ALLOWED_BUT_UNKNOWN;
                    }

                    public MailboxMetaData.Selectability getSelectability() {
                        return MailboxMetaData.Selectability.NOSELECT;
                    }

                    public char getHierarchyDelimiter() {
                        return mailboxSession.getPathDelimiter();
                    }

                    public MailboxPath getPath() {
                        return mailboxPath;
                    }

                    public MailboxId getId() {
                        return null;
                    }
                });
            } else {
                void var13_17;
                String finalReferencename = referenceName;
                if (mailboxName.charAt(0) == '#') {
                    finalReferencename = "";
                }
                isRelative = (finalReferencename + mailboxName).charAt(0) != '#';
                finalReferencename = CharsetUtil.decodeModifiedUTF7(finalReferencename);
                Object var13_14 = null;
                if (isRelative) {
                    MailboxPath mailboxPath = new MailboxPath("#private", user, finalReferencename);
                } else {
                    MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(finalReferencename);
                }
                results = this.getMailboxManager().search(new MailboxQuery((MailboxPath)var13_17, CharsetUtil.decodeModifiedUTF7(mailboxName), mailboxSession.getPathDelimiter()), mailboxSession);
            }
            for (MailboxMetaData mailboxMetaData : results) {
                this.processResult(responder, isRelative, mailboxMetaData, this.getMailboxType(session, mailboxTyper, mailboxMetaData.getPath()));
            }
            this.okComplete(command, tag, responder);
        }
        catch (MailboxException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("List failed", (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.SEARCH_FAILED);
        }
    }

    void processResult(ImapProcessor.Responder responder, boolean relative, MailboxMetaData listResult, MailboxType mailboxType) {
        char delimiter = listResult.getHierarchyDelimiter();
        String mailboxName = this.mailboxName(relative, listResult.getPath(), delimiter);
        MailboxMetaData.Children inferiors = listResult.inferiors();
        boolean noInferior = MailboxMetaData.Children.NO_INFERIORS.equals((Object)inferiors);
        boolean hasChildren = MailboxMetaData.Children.HAS_CHILDREN.equals((Object)inferiors);
        boolean hasNoChildren = MailboxMetaData.Children.HAS_NO_CHILDREN.equals((Object)inferiors);
        boolean noSelect = false;
        boolean marked = false;
        boolean unmarked = false;
        switch (listResult.getSelectability()) {
            case MARKED: {
                marked = true;
                break;
            }
            case UNMARKED: {
                unmarked = true;
                break;
            }
            case NOSELECT: {
                noSelect = true;
                break;
            }
        }
        responder.respond(this.createResponse(noInferior, noSelect, marked, unmarked, hasChildren, hasNoChildren, mailboxName, delimiter, mailboxType));
    }

    private MailboxType getMailboxType(ImapSession session, MailboxTyper mailboxTyper, MailboxPath path) {
        MailboxType result = MailboxType.OTHER;
        if (mailboxTyper != null) {
            result = mailboxTyper.getMailboxType(session, path);
        }
        return result;
    }

    @Override
    protected boolean isAcceptable(ImapMessage message) {
        return ListRequest.class.equals(message.getClass());
    }
}

