/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.GetQuotaRootRequest;
import org.apache.james.imap.message.response.QuotaResponse;
import org.apache.james.imap.message.response.QuotaRootResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.SimpleMailboxACL;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.metrics.api.MetricFactory;

public class GetQuotaRootProcessor
extends AbstractMailboxProcessor<GetQuotaRootRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> CAPABILITIES = Collections.singletonList("QUOTA");
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaManager quotaManager;

    public GetQuotaRootProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, QuotaRootResolver quotaRootResolver, QuotaManager quotaManager, MetricFactory metricFactory) {
        super(GetQuotaRootRequest.class, next, mailboxManager, factory, metricFactory);
        this.quotaRootResolver = quotaRootResolver;
        this.quotaManager = quotaManager;
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected void doProcess(GetQuotaRootRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(message.getMailboxName());
        try {
            if (mailboxManager.hasRight(mailboxPath, SimpleMailboxACL.Rfc4314Rights.r_Read_RIGHT, mailboxSession)) {
                QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(mailboxPath);
                Quota messageQuota = this.quotaManager.getMessageQuota(quotaRoot);
                Quota storageQuota = this.quotaManager.getStorageQuota(quotaRoot);
                responder.respond(new QuotaRootResponse(message.getMailboxName(), quotaRoot.getValue()));
                responder.respond(new QuotaResponse("MESSAGE", quotaRoot.getValue(), messageQuota));
                responder.respond(new QuotaResponse("STORAGE", quotaRoot.getValue(), storageQuota));
                this.okComplete(command, tag, responder);
            } else {
                Object[] params = new Object[]{SimpleMailboxACL.Rfc4314Rights.r_Read_RIGHT.toString(), command.getName(), message.getMailboxName()};
                HumanReadableText humanReadableText = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
                this.no(command, tag, responder, humanReadableText);
            }
        }
        catch (MailboxException me) {
            this.taggedBad(command, tag, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX);
        }
    }
}

