/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.GetQuotaRequest;
import org.apache.james.imap.message.response.QuotaResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.SimpleMailboxACL;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.metrics.api.MetricFactory;

public class GetQuotaProcessor
extends AbstractMailboxProcessor<GetQuotaRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> CAPABILITIES = Collections.singletonList("QUOTA");
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;

    public GetQuotaProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, MetricFactory metricFactory) {
        super(GetQuotaRequest.class, next, mailboxManager, factory, metricFactory);
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected void doProcess(GetQuotaRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        try {
            if (this.hasRight(message.getQuotaRoot(), session)) {
                QuotaRoot quotaRoot = this.quotaRootResolver.createQuotaRoot(message.getQuotaRoot());
                Quota messageQuota = this.quotaManager.getMessageQuota(quotaRoot);
                Quota storageQuota = this.quotaManager.getStorageQuota(quotaRoot);
                responder.respond(new QuotaResponse("MESSAGE", quotaRoot.getValue(), messageQuota));
                responder.respond(new QuotaResponse("STORAGE", quotaRoot.getValue(), storageQuota));
                this.okComplete(command, tag, responder);
            } else {
                Object[] params = new Object[]{SimpleMailboxACL.Rfc4314Rights.r_Read_RIGHT.toString(), command.getName(), "Any mailbox of this user USER"};
                HumanReadableText humanReadableText = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
                this.no(command, tag, responder, humanReadableText);
            }
        }
        catch (MailboxException me) {
            this.taggedBad(command, tag, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX);
        }
    }

    private boolean hasRight(String quotaRoot, ImapSession session) throws MailboxException {
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        List mailboxList = this.quotaRootResolver.retrieveAssociatedMailboxes(this.quotaRootResolver.createQuotaRoot(quotaRoot), mailboxSession);
        for (MailboxPath mailboxPath : mailboxList) {
            if (!this.getMailboxManager().hasRight(mailboxPath, SimpleMailboxACL.Rfc4314Rights.r_Read_RIGHT, mailboxSession)) continue;
            return true;
        }
        return false;
    }
}

