/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.GetAnnotationRequest;
import org.apache.james.imap.message.response.AnnotationResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;

public class GetAnnotationProcessor
extends AbstractMailboxProcessor<GetAnnotationRequest>
implements CapabilityImplementingProcessor {
    public GetAnnotationProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(GetAnnotationRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return ImmutableList.of((Object)"ANNOTATION");
    }

    @Override
    protected void doProcess(GetAnnotationRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        try {
            this.proceed(message, session, tag, command, responder);
        }
        catch (MailboxNotFoundException e) {
            session.getLog().info("The command: {} is failed because not found mailbox {}", (Object)command.getName(), (Object)message.getMailboxName());
            this.no(command, tag, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate());
        }
        catch (MailboxException e) {
            session.getLog().info("The command: {} on mailbox {} is failed", (Object)command.getName(), (Object)message.getMailboxName());
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    private void proceed(GetAnnotationRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) throws MailboxException {
        String mailboxName = message.getMailboxName();
        Optional<Integer> maxsize = message.getMaxsize();
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
        List<MailboxAnnotation> mailboxAnnotations = this.getMailboxAnnotations(session, message.getKeys(), message.getDepth(), mailboxPath);
        Optional<Integer> maximumOversizedSize = this.getMaxSizeValue(mailboxAnnotations, maxsize);
        this.respond(tag, command, responder, mailboxName, mailboxAnnotations, maxsize, maximumOversizedSize);
    }

    private void respond(String tag, ImapCommand command, ImapProcessor.Responder responder, String mailboxName, List<MailboxAnnotation> mailboxAnnotations, Optional<Integer> maxsize, Optional<Integer> maximumOversizedSize) {
        if (maximumOversizedSize.isPresent()) {
            responder.respond(new AnnotationResponse(mailboxName, this.filterItemsBySize(responder, mailboxName, mailboxAnnotations, maxsize)));
            this.okComplete(command, tag, StatusResponse.ResponseCode.longestMetadataEntry(((Integer)maximumOversizedSize.get()).intValue()), responder);
        } else {
            responder.respond(new AnnotationResponse(mailboxName, mailboxAnnotations));
            this.okComplete(command, tag, responder);
        }
    }

    private Optional<Integer> getMaxSizeValue(final List<MailboxAnnotation> mailboxAnnotations, Optional<Integer> maxsize) {
        if (maxsize.isPresent()) {
            return (Optional)maxsize.transform((Function)new Function<Integer, Optional<Integer>>(){

                public Optional<Integer> apply(Integer input) {
                    return GetAnnotationProcessor.this.getMaxSizeOfOversizedItems(mailboxAnnotations, input);
                }
            }).get();
        }
        return Optional.absent();
    }

    private List<MailboxAnnotation> filterItemsBySize(ImapProcessor.Responder responder, String mailboxName, List<MailboxAnnotation> mailboxAnnotations, final Optional<Integer> maxsize) {
        Predicate<MailboxAnnotation> lowerPredicate = new Predicate<MailboxAnnotation>(){

            public boolean apply(final MailboxAnnotation input) {
                return (Boolean)maxsize.transform((Function)new Function<Integer, Boolean>(){

                    public Boolean apply(Integer maxSizeInput) {
                        return input.size() <= maxSizeInput;
                    }
                }).or((Object)true);
            }
        };
        return FluentIterable.from(mailboxAnnotations).filter((Predicate)lowerPredicate).toList();
    }

    private List<MailboxAnnotation> getMailboxAnnotations(ImapSession session, Set<MailboxAnnotationKey> keys, GetAnnotationRequest.Depth depth, MailboxPath mailboxPath) throws MailboxException {
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        switch (depth) {
            case ZERO: {
                return this.getMailboxAnnotationsWithDepthZero(keys, mailboxPath, mailboxSession);
            }
            case ONE: {
                return this.getMailboxManager().getAnnotationsByKeysWithOneDepth(mailboxPath, mailboxSession, keys);
            }
            case INFINITY: {
                return this.getMailboxManager().getAnnotationsByKeysWithAllDepth(mailboxPath, mailboxSession, keys);
            }
        }
        throw new NotImplementedException();
    }

    private List<MailboxAnnotation> getMailboxAnnotationsWithDepthZero(Set<MailboxAnnotationKey> keys, MailboxPath mailboxPath, MailboxSession mailboxSession) throws MailboxException {
        if (keys.isEmpty()) {
            return this.getMailboxManager().getAllAnnotations(mailboxPath, mailboxSession);
        }
        return this.getMailboxManager().getAnnotationsByKeys(mailboxPath, mailboxSession, keys);
    }

    private Optional<Integer> getMaxSizeOfOversizedItems(List<MailboxAnnotation> mailboxAnnotations, final Integer maxsize) {
        Predicate<MailboxAnnotation> filterOverSizedAnnotation = new Predicate<MailboxAnnotation>(){

            public boolean apply(MailboxAnnotation input) {
                return input.size() > maxsize;
            }
        };
        Function<MailboxAnnotation, Integer> transformToSize = new Function<MailboxAnnotation, Integer>(){

            public Integer apply(MailboxAnnotation input) {
                return input.size();
            }
        };
        ImmutableSortedSet overLimitSizes = FluentIterable.from(mailboxAnnotations).filter((Predicate)filterOverSizedAnnotation).transform((Function)transformToSize).toSortedSet((Comparator)new Comparator<Integer>(){

            @Override
            public int compare(Integer annotationSize1, Integer annotationSize2) {
                return annotationSize2.compareTo(annotationSize1);
            }
        });
        if (overLimitSizes.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)overLimitSizes.first());
    }
}

