/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.ExpungeRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.metrics.api.MetricFactory;

public class ExpungeProcessor
extends AbstractMailboxProcessor<ExpungeRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> UIDPLUS = Collections.unmodifiableList(Arrays.asList("UIDPLUS"));

    public ExpungeProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(ExpungeRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(ExpungeRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        try {
            MessageManager mailbox = this.getSelectedMailbox(session);
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
            int expunged = 0;
            MessageManager.MetaData mdata = mailbox.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT);
            if (!mdata.isWriteable()) {
                this.no(command, tag, responder, HumanReadableText.MAILBOX_IS_READ_ONLY);
            } else {
                IdRange[] ranges = request.getUidSet();
                if (ranges == null) {
                    expunged = this.expunge(mailbox, MessageRange.all(), session, mailboxSession);
                } else {
                    for (IdRange range : ranges) {
                        MessageRange mRange = this.messageRange(session.getSelected(), range, true);
                        if (mRange == null) continue;
                        expunged += this.expunge(mailbox, mRange, session, mailboxSession);
                    }
                }
                this.unsolicitedResponses(session, responder, false);
                if (EnableProcessor.getEnabledCapabilities(session).contains("QRESYNC") && expunged > 0) {
                    this.okComplete(command, tag, StatusResponse.ResponseCode.highestModSeq(mdata.getHighestModSeq()), responder);
                } else {
                    this.okComplete(command, tag, responder);
                }
            }
        }
        catch (MessageRangeException e) {
            if (session.getLog().isDebugEnabled()) {
                session.getLog().debug("Expunge failed", (Throwable)e);
            }
            this.taggedBad(command, tag, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("Expunge failed for mailbox " + session.getSelected().getPath(), (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    private int expunge(MessageManager mailbox, MessageRange range, ImapSession session, MailboxSession mailboxSession) throws MailboxException {
        Iterator it = mailbox.expunge(range, mailboxSession);
        SelectedMailbox selected = session.getSelected();
        int expunged = 0;
        if (mailboxSession != null) {
            while (it.hasNext()) {
                MessageUid uid = (MessageUid)it.next();
                selected.removeRecent(uid);
                ++expunged;
            }
        }
        return expunged;
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return UIDPLUS;
    }
}

