/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.DeleteACLRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.SimpleMailboxACL;
import org.apache.james.metrics.api.MetricFactory;
import org.slf4j.Logger;

public class DeleteACLProcessor
extends AbstractMailboxProcessor<DeleteACLRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> CAPABILITIES = Collections.singletonList("ACL");

    public DeleteACLProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(DeleteACLRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(DeleteACLRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        String mailboxName = message.getMailboxName();
        String identifier = message.getIdentifier();
        try {
            MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
            mailboxManager.getMailbox(mailboxPath, mailboxSession);
            if (!mailboxManager.hasRight(mailboxPath, SimpleMailboxACL.Rfc4314Rights.l_Lookup_RIGHT, mailboxSession)) {
                this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
            } else if (!mailboxManager.hasRight(mailboxPath, SimpleMailboxACL.Rfc4314Rights.a_Administer_RIGHT, mailboxSession)) {
                Object[] params = new Object[]{SimpleMailboxACL.Rfc4314Rights.a_Administer_RIGHT.toString(), command.getName(), mailboxName};
                HumanReadableText text = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
                this.no(command, tag, responder, text);
            } else {
                SimpleMailboxACL.SimpleMailboxACLEntryKey key = new SimpleMailboxACL.SimpleMailboxACLEntryKey(identifier);
                mailboxManager.setRights(mailboxPath, (MailboxACL.MailboxACLCommand)new SimpleMailboxACL.SimpleMailboxACLCommand((MailboxACL.MailboxACLEntryKey)key, MailboxACL.EditMode.REPLACE, null), mailboxSession);
                this.okComplete(command, tag, responder);
            }
        }
        catch (UnsupportedRightException e) {
            Object[] params = new Object[]{Character.valueOf(e.getUnsupportedRight())};
            HumanReadableText text = new HumanReadableText("org.apache.james.imap.UNSUPPORTED_RIGHT", "The {0} right is not supported.", params);
            this.taggedBad(command, tag, responder, text);
        }
        catch (MailboxNotFoundException e) {
            this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
        }
        catch (MailboxException e) {
            Logger log = session.getLog();
            if (log.isInfoEnabled()) {
                log.info(command.getName() + " failed for mailbox " + mailboxName, (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }
}

