/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.display.CharsetUtil;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.CapabilityRequest;
import org.apache.james.imap.message.response.CapabilityResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;

public class CapabilityProcessor
extends AbstractMailboxProcessor<CapabilityRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> CAPS;
    private final List<CapabilityImplementingProcessor> capabilities = new ArrayList<CapabilityImplementingProcessor>();
    private final Set<String> disabledCaps = new HashSet<String>();

    public CapabilityProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, List<CapabilityImplementingProcessor> capabilities, MetricFactory metricFactory) {
        this(next, mailboxManager, factory, metricFactory);
        capabilities.addAll(capabilities);
    }

    public CapabilityProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(CapabilityRequest.class, next, mailboxManager, factory, metricFactory);
        this.capabilities.add(this);
    }

    @Override
    public void configure(ImapConfiguration imapConfiguration) {
        super.configure(imapConfiguration);
        this.disabledCaps.addAll((Collection<String>)imapConfiguration.getDisabledCaps());
        if (this.shouldDisableCondstore(imapConfiguration)) {
            this.disabledCaps.add("CONDSTORE");
        }
    }

    private boolean shouldDisableCondstore(ImapConfiguration imapConfiguration) {
        return !imapConfiguration.isCondstoreEnable() && !this.disabledCaps.contains("CONDSTORE");
    }

    @Override
    protected void doProcess(CapabilityRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        CapabilityResponse result = new CapabilityResponse(this.getSupportedCapabilities(session));
        responder.respond(result);
        this.unsolicitedResponses(session, responder, false);
        this.okComplete(command, tag, responder);
    }

    public void addProcessor(CapabilityImplementingProcessor implementor) {
        this.capabilities.add(implementor);
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    public Set<String> getSupportedCapabilities(ImapSession session) {
        HashSet<String> caps = new HashSet<String>();
        for (CapabilityImplementingProcessor capability : this.capabilities) {
            caps.addAll(capability.getImplementedCapabilities(session));
        }
        caps.removeAll(this.disabledCaps);
        return caps;
    }

    static {
        ArrayList<String> caps = new ArrayList<String>();
        caps.add("IMAP4rev1");
        caps.add("LITERAL+");
        caps.add("CHILDREN");
        if (CharsetUtil.getAvailableCharsetNames().contains("UTF-8")) {
            caps.add("I18NLEVEL=1");
        }
        caps.add("CONDSTORE");
        CAPS = Collections.unmodifiableList(caps);
    }
}

