/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.AbstractMessageRangeRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.metrics.api.MetricFactory;

public abstract class AbstractMessageRangeProcessor<M extends AbstractMessageRangeRequest>
extends AbstractMailboxProcessor<M> {
    public AbstractMessageRangeProcessor(Class<M> acceptableClass, ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(acceptableClass, next, mailboxManager, factory, metricFactory);
    }

    protected abstract List<MessageRange> process(MailboxPath var1, SelectedMailbox var2, MailboxSession var3, MailboxManager var4, MessageRange var5) throws MailboxException;

    protected abstract String getOperationName();

    @Override
    protected void doProcess(M request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxPath targetMailbox = PathConverter.forSession(session).buildFullPath(((AbstractMessageRangeRequest)request).getMailboxName());
        IdRange[] idSet = ((AbstractMessageRangeRequest)request).getIdSet();
        boolean useUids = ((AbstractMessageRangeRequest)request).isUseUids();
        SelectedMailbox currentMailbox = session.getSelected();
        try {
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
            MailboxManager mailboxManager = this.getMailboxManager();
            boolean mailboxExists = mailboxManager.mailboxExists(targetMailbox, mailboxSession);
            if (!mailboxExists) {
                this.no(command, tag, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate());
            } else {
                MessageManager mailbox = mailboxManager.getMailbox(targetMailbox, mailboxSession);
                ArrayList<IdRange> resultRanges = new ArrayList<IdRange>();
                for (IdRange range : idSet) {
                    MessageRange messageSet = this.messageRange(currentMailbox, range, useUids);
                    if (messageSet == null) continue;
                    List<MessageRange> processedUids = this.process(targetMailbox, currentMailbox, mailboxSession, mailboxManager, messageSet);
                    for (MessageRange mr : processedUids) {
                        resultRanges.add(new IdRange(mr.getUidFrom().asLong(), mr.getUidTo().asLong()));
                    }
                }
                IdRange[] resultUids = IdRange.mergeRanges(resultRanges).toArray(new IdRange[0]);
                Long uidValidity = mailbox.getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_UNSEEN).getUidValidity();
                this.unsolicitedResponses(session, responder, useUids);
                this.okComplete(command, tag, StatusResponse.ResponseCode.copyUid(uidValidity, idSet, resultUids), responder);
            }
        }
        catch (MessageRangeException e) {
            if (session.getLog().isDebugEnabled()) {
                session.getLog().debug(this.getOperationName() + " failed from mailbox " + currentMailbox.getPath() + " to " + targetMailbox + " for invalid sequence-set " + idSet.toString(), (Throwable)e);
            }
            this.taggedBad(command, tag, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info(this.getOperationName() + " failed from mailbox " + currentMailbox.getPath() + " to " + targetMailbox + " for sequence-set " + idSet.toString(), (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }
}

