/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.NotAdminException;
import org.apache.james.mailbox.exception.UserDoesNotExistException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;

public abstract class AbstractAuthProcessor<M extends ImapRequest>
extends AbstractMailboxProcessor<M> {
    private static final String ATTRIBUTE_NUMBER_OF_FAILURES = "org.apache.james.imap.processor.imap4rev1.NUMBER_OF_FAILURES";
    private static final int MAX_FAILURES = 3;

    public AbstractAuthProcessor(Class<M> acceptableClass, ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(acceptableClass, next, mailboxManager, factory, metricFactory);
    }

    protected void doAuth(AuthenticationAttempt authenticationAttempt, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder, HumanReadableText failed) {
        Preconditions.checkArgument((!authenticationAttempt.isDelegation() ? 1 : 0) != 0);
        try {
            boolean authFailure = false;
            if (authenticationAttempt.getAuthenticationId() == null) {
                authFailure = true;
            }
            if (!authFailure) {
                MailboxManager mailboxManager = this.getMailboxManager();
                try {
                    MailboxSession mailboxSession = mailboxManager.login(authenticationAttempt.getAuthenticationId(), authenticationAttempt.getPassword(), session.getLog());
                    session.authenticated();
                    session.setAttribute("org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY", mailboxSession);
                    this.provisionInbox(session, mailboxManager, mailboxSession);
                    this.okComplete(command, tag, responder);
                }
                catch (BadCredentialsException e) {
                    authFailure = true;
                }
            }
            if (authFailure) {
                this.manageFailureCount(session, tag, command, responder, failed);
            }
        }
        catch (MailboxException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("Login failed", (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    protected void doAuthWithDelegation(AuthenticationAttempt authenticationAttempt, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder, HumanReadableText failed) {
        Preconditions.checkArgument((boolean)authenticationAttempt.isDelegation());
        try {
            boolean authFailure = false;
            if (authenticationAttempt.getAuthenticationId() == null) {
                authFailure = true;
            }
            if (!authFailure) {
                MailboxManager mailboxManager = this.getMailboxManager();
                try {
                    MailboxSession mailboxSession = mailboxManager.loginAsOtherUser(authenticationAttempt.getAuthenticationId(), authenticationAttempt.getPassword(), (String)authenticationAttempt.getDelegateUserName().get(), session.getLog());
                    session.authenticated();
                    session.setAttribute("org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY", mailboxSession);
                    this.provisionInbox(session, mailboxManager, mailboxSession);
                    this.okComplete(command, tag, responder);
                }
                catch (BadCredentialsException e) {
                    authFailure = true;
                }
            }
            if (authFailure) {
                this.manageFailureCount(session, tag, command, responder, failed);
            }
        }
        catch (UserDoesNotExistException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("User " + authenticationAttempt.getAuthenticationId() + " does not exist", (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.USER_DOES_NOT_EXIST);
        }
        catch (NotAdminException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("User " + authenticationAttempt.getDelegateUserName() + " is not an admin", (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.NOT_AN_ADMIN);
        }
        catch (MailboxException e) {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("Login failed", (Throwable)e);
            }
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    private void provisionInbox(ImapSession session, MailboxManager mailboxManager, MailboxSession mailboxSession) throws MailboxException {
        block5: {
            MailboxPath inboxPath = PathConverter.forSession(session).buildFullPath("INBOX");
            if (mailboxManager.mailboxExists(inboxPath, mailboxSession)) {
                if (session.getLog().isDebugEnabled()) {
                    session.getLog().debug("INBOX exists. No need to create it.");
                }
            } else {
                try {
                    session.getLog().debug("INBOX does not exist. Creating it.");
                    mailboxManager.createMailbox(inboxPath, mailboxSession);
                }
                catch (MailboxExistsException e) {
                    if (!session.getLog().isDebugEnabled()) break block5;
                    session.getLog().debug("Mailbox created by concurrent call. Safe to ignore this exception.");
                }
            }
        }
    }

    protected void manageFailureCount(ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder, HumanReadableText failed) {
        Integer currentNumberOfFailures = (Integer)session.getAttribute(ATTRIBUTE_NUMBER_OF_FAILURES);
        int failures = currentNumberOfFailures == null ? 1 : currentNumberOfFailures + 1;
        if (failures < 3) {
            session.setAttribute(ATTRIBUTE_NUMBER_OF_FAILURES, failures);
            this.no(command, tag, responder, failed);
        } else {
            if (session.getLog().isInfoEnabled()) {
                session.getLog().info("Too many authentication failures. Closing connection.");
            }
            this.bye(responder, HumanReadableText.TOO_MANY_FAILURES);
            session.logout();
        }
    }

    protected static AuthenticationAttempt delegation(String authorizeId, String authenticationId, String password) {
        return new AuthenticationAttempt((Optional<String>)Optional.of((Object)authorizeId), authenticationId, password);
    }

    protected static AuthenticationAttempt noDelegation(String authenticationId, String password) {
        return new AuthenticationAttempt((Optional<String>)Optional.absent(), authenticationId, password);
    }

    protected static class AuthenticationAttempt {
        private final Optional<String> delegateUserName;
        private final String authenticationId;
        private final String password;

        public AuthenticationAttempt(Optional<String> delegateUserName, String authenticationId, String password) {
            this.delegateUserName = delegateUserName;
            this.authenticationId = authenticationId;
            this.password = password;
        }

        public boolean isDelegation() {
            return this.delegateUserName.isPresent() && !((String)this.delegateUserName.get()).equals(this.authenticationId);
        }

        public Optional<String> getDelegateUserName() {
            return this.delegateUserName;
        }

        public String getAuthenticationId() {
            return this.authenticationId;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

