/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.response;

import org.apache.james.imap.api.process.MailboxType;

public abstract class AbstractListingResponse {
    private final boolean children;
    private final boolean noChildren;
    private final boolean noInferiors;
    private final boolean noSelect;
    private final boolean marked;
    private final boolean unmarked;
    private final char hierarchyDelimiter;
    private final String name;
    private final MailboxType type;

    public AbstractListingResponse(boolean noInferiors, boolean noSelect, boolean marked, boolean unmarked, boolean hasChildren, boolean hasNoChildren, String name, char hierarchyDelimiter, MailboxType type) {
        this.noInferiors = noInferiors;
        this.noSelect = noSelect;
        this.marked = marked;
        this.unmarked = unmarked;
        this.children = hasChildren;
        this.noChildren = hasNoChildren;
        this.name = name;
        this.hierarchyDelimiter = hierarchyDelimiter;
        this.type = type;
    }

    public final char getHierarchyDelimiter() {
        return this.hierarchyDelimiter;
    }

    public final boolean isMarked() {
        return this.marked;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isNoInferiors() {
        return this.noInferiors;
    }

    public final boolean isNoSelect() {
        return this.noSelect;
    }

    public final boolean isUnmarked() {
        return this.unmarked;
    }

    public boolean hasNoChildren() {
        return this.noChildren;
    }

    public boolean hasChildren() {
        return this.children;
    }

    public MailboxType getType() {
        return this.type;
    }

    public final boolean isNameAttributed() {
        return this.noInferiors || this.noSelect || this.marked || this.unmarked || this.children || this.noChildren || !MailboxType.OTHER.equals((Object)this.type);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.children ? 1231 : 1237);
        result = 31 * result + this.hierarchyDelimiter;
        result = 31 * result + this.type.ordinal();
        result = 31 * result + (this.marked ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.noChildren ? 1231 : 1237);
        result = 31 * result + (this.noInferiors ? 1231 : 1237);
        result = 31 * result + (this.noSelect ? 1231 : 1237);
        result = 31 * result + (this.unmarked ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractListingResponse other = (AbstractListingResponse)obj;
        if (this.children != other.children) {
            return false;
        }
        if (this.hierarchyDelimiter != other.hierarchyDelimiter) {
            return false;
        }
        if (this.marked != other.marked) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.noChildren != other.noChildren) {
            return false;
        }
        if (this.noInferiors != other.noInferiors) {
            return false;
        }
        if (this.noSelect != other.noSelect) {
            return false;
        }
        if (this.unmarked != other.unmarked) {
            return false;
        }
        return this.type.equals((Object)other.type);
    }

    public String toString() {
        String TAB = " ";
        return this.getClass().getName() + " ( noInferiors = " + this.noInferiors + " " + "noSelect = " + this.noSelect + " " + "marked = " + this.marked + " " + "unmarked = " + this.unmarked + " " + "hierarchyDelimiter = " + this.hierarchyDelimiter + " " + "name = " + this.name + " " + "type = " + (Object)((Object)this.type) + " " + " )";
    }
}

